VERSION 5.00
Begin VB.UserControl ucListView 
   AutoRedraw      =   -1  'True
   BackColor       =   &H80000005&
   ClientHeight    =   1800
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3045
   ClipControls    =   0   'False
   EditAtDesignTime=   -1  'True
   FillColor       =   &H80000008&
   HasDC           =   0   'False
   ScaleHeight     =   120
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   203
   ToolboxBitmap   =   "ucListView.ctx":0000
End
Attribute VB_Name = "ucListView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'========================================================================================
' User control:  ucListView.ctl
' Author:        Original by Carles P.V. (*) Modified by Raul338 (raul338@elhacker.net)
' Dependencies:  None :D
' Last revision: 2011.11.27
' Version:       2.5.1
' Thanks To:
'            Leandro Ascierto (http://www.leandroascierto.com.ar)
'            Jonney Wu
'----------------------------------------------------------------------------------------
'
' (*) based on:
'
'     - vbalListViewCtl by Steve McMahon - 2003
'       http://vbaccelerator.com/home/VB/Code/Controls/ListView/article.asp
'
'     - Common Control Routines
'       http://vbnet.mvps.org/index.html?code/comctl
'
'     - MSDN
'       http://msdn.microsoft.com/library/en-us/shellcc/platform/commctls/listview/reflist.asp
'----------------------------------------------------------------------------------------
'     Self-Subclassing UserControl template (IDE safe).
'
'     From original post by LaVolpe
'
'     Self-subclassing Controls/Forms - NO dependencies
'     http://www.planet-source-code.com/vb/scripts/ShowCode.asp?txtCodeId=68737&lngWId=1
'----------------------------------------------------------------------------------------
'     Traping TabStop + navigation keys. (Reformed by Raul338)
'
'     From original post by Vlad Vissoultchev:
'
'     How to capture Tab/Enter/Esc on your custom UserControl
'     http://www.planet-source-code.com/vb/scripts/ShowCode.asp?txtCodeId=41506&lngWId=1
'----------------------------------------------------------------------------------------
'     CallInterface Function by AndRAY (To remove TLB and module)
'
'     From Original post "ITaskBarList3 (implementing Windows 7 taskbar features)"
'
'     http://www.planetsourcecode.com/vb/scripts/ShowCode.asp?lngWId=1&txtCodeId=72856
'========================================================================================
'
' History:
'
'   * 1.0.0: - First release.
'   * 1.1.x: - Added Sort() function.
'   * 1.2.x: - Added Header (column) image support.
'   * 1.3.x: - Improved Header image support and added ColumnFixedWidth property.
'   * 1.4.0: - Added basic custom-draw support (Text fore and back color) in [Details] mode.
'              Notice: Chain of draw-stage notifications is a per-item chain (row). If desired
'                      effect is, for example, highlighting a column, you should specify next
'                      subitems (columns) colors, that is, restore to default.
'            - Added Refresh() Method.
'   * 1.4.1: - Fixed custom-draw routine. Crash when XP theme enabled ([Details] mode).
'              Thanks to Dana Seaman.
'   * 1.4.2: - Custom image size for image-lists).
'              Thanks to Dana Seaman for suggestion.
'   * 1.4.3: - Faster Sort routines: LVM_SORTITEMSEX instead of LVM_SORTITEMS
'              Callback lparam1 and lparam2 are already indexes of both compared items.
'   * 1.4.4: - Fixed crash when XP theme enabled.
'              Cause: when custom-draw (report) the uNMH.hwndFrom param. was not checked.
'   Following Modifications by Raul338
'   * 1.4.5: - Added ColumnOrder And Groups Suppourt
'              Added ProgressBar in Column (original from Leandro Ascierto)
'              Added IconSpacing, HeaderMenu, FilterBar, Background Style like XP Folder
'   * 2.5.1: - Updated Subclassing Functions (Using LaVolpe modifications on Paul Caton subclassing)
'              Removed mListViewEx.bas. Update ProgressBar in Columns With Groups
'              Removed mIOleInPlaceActivate.bas (Included in the ctl)
'========================================================================================
'
' Important:
'
'   Item, column, groups and image (icon) indexing is zero-based.
'
' Quick reference:
'
'   Methods:
'
'     - F  Initialize() :Boolean
'     - F  InitializeImageListSmall([ImageWidth], [ImageHeight]) :Boolean
'     - F  InitializeImageListLarge([ImageWidth], [ImageHeight]) :Boolean
'     - F  InitializeImageListHeader([ImageWidth], [ImageHeight]) :Boolean
'     - S  Refresh()
'
'     - F  Clear() :Boolean
'     - F  Sort([Column], [<SortOrder>], [<SortType>]) :Boolean
'     - F  BackgroundPictureSet(URL) :Boolean
'
'     - F  ColumnAdd(Column, Text, Width, [<Align>], [Icon]) :Boolean
'     - F  ColumnRemove(Column) :Boolean
'     - F  ColumnAutosize(Column, [<AutosizeType>]) :Boolean

'     - F  GroupAdd(Index, Header, [HeaderAlign], [Footer], [FooterAlign]) :Long
'     - F  GroupRemove(Index) :Boolean
'     - S  GroupClear()

'     - F  ItemAdd(Item, Text, Icon, Indent) :Boolean
'     - F  ItemRemove(Item) :Boolean
'     - F  ItemEnsureVisible(Item) :Boolean
'     - F  ItemFindText(Text, [StartItem], [<Coincidence>]) :Long
'     - F  ItemFindState(Text, [StartItem], [<State>]) :Long
'     - F  ItemHitTest(x, y) :Long
'     - F  SubItemSet(Item, SubItem, Text, Icon) :Boolean
'
'     - F  ImageListSmall_AddBitmap(hBitmap, [MaskColor]) :Long
'     - F  ImageListSmall_AddIcon(hIcon) :Long
'     - F  ImageListLarge_AddBitmap(hBitmap, [MaskColor]) :Long
'     - F  ImageListLarge_AddIcon(hIcon) :Long
'     - F  ImageListHeader_AddBitmap(hBitmap, [MaskColor]) :Long
'     - F  ImageListHeader_AddIcon(hIcon) :Long
'
'   Properties (run-time):
'
'     - RW ColumnText(Column) :String
'     - RW ColumnWidth(Column) :Long
'     - RW ColumnAlign(Column) :eColumnAlignConstants
'     - RW ColumnIcon(Column) :Long
'     - RW ColumnOrder(Column) :eSortOrderConstants
'
'     - R  GroupsCount() :Long
'     - RW GroupsEnable() :Boolean
'     - RW GroupHeaderText(Group) :String
'     - RW GroupHeaderAlign(Group) :eAlignConstants
'     - RW GroupFooterText(Group) :String
'     - RW GroupFooterAlign(Group) :eAlignConstants
'     - RW GroupCollapsible(Group) :Boolean
'     - RW GroupCollapsed(Group) :Boolean

'     - RW GroupSubtitle(Group) :String
'
'     - RW ItemText(Item) :String
'     - RW ItemIcon(Item) :Long
'     - RW ItemIndent(Item) :Long
'     - RW ItemSelected(Item) :Boolean (Item = -1 -> all items)
'     - RW ItemFocused(Item) :Boolean
'     - RW ItemChecked(Item) :Boolean (Item = -1 -> all items)
'     - RW ItemGhosted(Item) :Boolean (Item = -1 -> all items)
'     - RW SubItemText(Item, SubItem) :String
'     - RW SubItemIcon(Item, SubItem) :Long
'
'     - RW BackColor() :OLE_COLOR
'     - RW BorderStyle() :eBorderStyleConstants
'     - R  ColumnCount() :Long
'     - R  Count() :Long
'     - RW CheckBoxes() :Boolean
'     - RW Enabled() :Boolean
'     - RW Font() :StdFont
'     - RW ForeColor() :OLE_COLOR
'     - RW FullRowSelect() :Boolean
'     - RW GridLines() :Boolean
'     - RW HeaderDragDrop() :Boolean
'     - RW HeaderFixedWidth() :Boolean
'     - RW HeaderFlat() :Boolean
'     - RW HeaderHide() :Boolean
'     - RW HideSelection() Boolean
'     - RW LabelEdit() :Boolean
'     - RW LabelTips() :Boolean
'     - RW MultiSelect() :Boolean
'     - RW OneClickActivate() :Boolean
'     - RW RaiseSubItemPrePaint() :Boolean
'     - RW ScaleMode() :ScaleModeConstants
'     - RW ScrollBarFlat() :Boolean
'     - R  SelectedCount() :Long
'     - RW SubItemImages() :Boolean
'     - RW TrackSelect() :Boolean
'     - RW UnderlineHot() :Boolean
'     - RW ViewMode() :eViewModeConstants
'
'   Events:
'     -    Click()
'     -    DblClick()
'     -    ItemClick(Item)
'     -    ItemCheck(Item)
'     -    ColumnClick(Column)
'     -    ColumnRightClick(Column)
'     -    KeyDown(KeyCode, Shift)
'     -    KeyPress(KeyAscii)
'     -    KeyUp(KeyCode, Shift)
'     -    MouseDown(Button, Shift, x, y)
'     -    MouseMove(Button, Shift, x, y)
'     -    MouseUp(Button, Shift, x, y)
'     -    MouseEnter()
'     -    MouseLeave()
'     -    BeforeLabelEdit(Cancel)
'     -    AfterLabelEdit(Cancel, NewString)
'     -    Resize()
'     -    OnSubItemPrePaint(Item, SubItem, TextBackColor, TextForeColor, Process)
'========================================================================================
'
'  Known issues:
'
'    * SubItem background incorrectly drawn (image not painted or background erased) when:
'      Background image + [vmDetails] ViewMode + FullRowSelect + SubItemImages
'      Solution?: Trap NM_CUSTOMDRAW notification -> fix SubItem draw.
'                 NM_CUSTOMDRAW: dwDrawStage:CDDS_PREPAINT -> CDRF_NOTIFYITEMDRAW
'                 NM_CUSTOMDRAW: dwDrawStage:CDDS_ITEMPREPAINT -> CDRF_NOTIFYSUBITEMDRAW
'                 NM_CUSTOMDRAW: dwDrawStage:CDDS_SUBITEM | CDDS_ITEMPREPAINT -> ...
'
'========================================================================================

Option Explicit

'-- API

'= Common controls initialization =======================================================

Private Declare Sub InitCommonControls Lib "COMCTL32" ()
Private Declare Function FreeLibrary Lib "kernel32" (ByVal hLibModule As Long) As Long
Private Declare Function LoadLibraryA Lib "kernel32" (ByVal lpLibFileName As String) As Long

'= Misc =================================================================================

Private Type POINTAPI
    X As Long
    Y As Long
End Type

Private Type RECT
    Left                    As Long
    Top                     As Long
    Right                   As Long
    Bottom                  As Long
End Type

Private Type SYSTEMTIME
    wYear                       As Integer
    wMonth                      As Integer
    wDayOfWeek                  As Integer
    wDay                        As Integer
    wHour                       As Integer
    wMinute                     As Integer
    wSecond                     As Integer
    wMilliseconds               As Integer
End Type

Private Type LOGFONT
    lfHeight         As Long
    lfWidth          As Long
    lfEscapement     As Long
    lfOrientation    As Long
    lfWeight         As Long
    lfItalic         As Byte
    lfUnderline      As Byte
    lfStrikeOut      As Byte
    lfCharSet        As Byte
    lfOutPrecision   As Byte
    lfClipPrecision  As Byte
    lfQuality        As Byte
    lfPitchAndFamily As Byte
    lfFaceName(32)   As Byte
End Type

Private Const LOGPIXELSY             As Long = 90
Private Const FW_NORMAL              As Long = 400
Private Const FW_BOLD                As Long = 700
Private Const FF_DONTCARE            As Long = 0
Private Const DEFAULT_QUALITY        As Long = 0
Private Const DEFAULT_PITCH          As Long = 0
Private Const DEFAULT_CHARSET        As Long = 1
Private Const NONANTIALIASED_QUALITY As Long = 3

Private Const CLR_NONE               As Long = &HFFFFFFFF
Private Const WM_MOUSELEAVE As Long = &H2A3

Private Enum TRACKMOUSEEVENT_FLAGS
    [TME_HOVER] = &H1&
    [TME_LEAVE] = &H2&
    [TME_QUERY] = &H40000000
    [TME_CANCEL] = &H80000000
End Enum

Private Type TRACKMOUSEEVENT_STRUCT
    cbSize      As Long
    dwFlags     As TRACKMOUSEEVENT_FLAGS
    hwndTrack   As Long
    dwHoverTime As Long
End Type

'= Window general =======================================================================
Private Declare Function GetFocus Lib "user32.dll" () As Long
Private Declare Function CompareStringW Lib "kernel32.dll" (ByVal Locale As Long, ByVal dwCmpFlags As Long, ByVal lpString1 As Long, ByVal cchCount1 As Long, ByVal lpString2 As Long, ByVal cchCount2 As Long) As Long
Private Const LOCALE_INVARIANT As Long = &H7F
Private Const SORT_STRINGSORT As Long = &H1000 'Treat punctuation the same as symbols.
Private Const NORM_IGNORECASE As Long = &H1 'Ignore case.

Private Const WM_SETREDRAW   As Long = 11
Private Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function GetWindowRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer
Private Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
Private Declare Function ScreenToClient Lib "user32" (ByVal hwnd As Long, lpPoint As POINTAPI) As Long
Private Declare Function RedrawWindow Lib "user32" (ByVal hwnd As Long, ByVal lprcUpdate As Long, ByVal hrgnUpdate As Long, ByVal Flags As Long) As Long
Private Const RDW_INVALIDATE          As Long = 1
Private Const RDW_INTERNALPAINT       As Long = 2
Private Const RDW_ERASE               As Long = 4

Private Const RDW_VALIDATE            As Long = 8
Private Const RDW_NOINTERNALPAINT     As Long = 10
Private Const RDW_NOERASE             As Long = 20

Private Const RDW_NOCHILDREN          As Long = 40
Private Const RDW_ALLCHILDREN         As Long = 80

Private Const RDW_UPDATENOW           As Long = 100
Private Const RDW_ERASENOW            As Long = 200

Private Const RDW_FRAME               As Long = 400
Private Const RDW_NOFRAME             As Long = 800

Private Declare Function SetFocus Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function TrackMouseEvent Lib "user32" (lpEventTrack As TRACKMOUSEEVENT_STRUCT) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageW" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function DestroyWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function CreateWindowEx Lib "user32" Alias "CreateWindowExW" (ByVal dwExStyle As Long, ByVal lpClassName As Long, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Private Const WS_EX_TOPMOST     As Long = &H8&
Private Const WS_EX_TRANSPARENT As Long = &H20
Private Const WS_EX_WINDOWEDGE  As Long = &H100&
Private Const WS_EX_CLIENTEDGE  As Long = &H200&
Private Const WS_EX_STATICEDGE  As Long = &H20000
Private Const WS_EX_COMPOSITED  As Long = &H2000000
Private Const WS_TABSTOP        As Long = &H10000
Private Const WS_THICKFRAME     As Long = &H40000
Private Const WS_BORDER         As Long = &H800000
Private Const WS_DISABLED       As Long = &H8000000
Private Const WS_VISIBLE        As Long = &H10000000
Private Const WS_CHILD          As Long = &H40000000

Private Declare Function EnableWindow Lib "user32" (ByVal hwnd As Long, ByVal fEnable As Long) As Long
Private Declare Function LoadImage Lib "user32" Alias "LoadImageA" (ByVal hInst As Long, ByVal lpsz As String, ByVal uType As Long, ByVal cxDesired As Long, ByVal cyDesired As Long, ByVal fuLoad As Long) As Long
Private Declare Function UpdateWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetActiveWindow Lib "user32" () As Long
Private Declare Function GetDeviceCaps Lib "gdi32" (ByVal hDC As Long, ByVal nIndex As Long) As Long
Private Declare Function CreateFontIndirect Lib "gdi32" Alias "CreateFontIndirectA" (lpLogFont As LOGFONT) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function SetWindowTheme Lib "UXTHEME" (ByVal hwnd As Long, ByVal pszSubAppName As Long, ByVal pszSubIdList As Long) As Long
Private Declare Function OleTranslateColor Lib "OLEPRO32" (ByVal OLE_COLOR As Long, ByVal hPalette As Long, pccolorref As Long) As Long
Private Declare Function lstrcpyW Lib "kernel32" (ByVal lpString1 As Long, ByVal lpString2 As Long) As Long
Private Declare Function lstrlenW Lib "kernel32" (ByVal lpString As Long) As Long
Private Declare Function GetVersion Lib "kernel32" () As Long
Private Declare Function MulDiv Lib "kernel32" (ByVal nNumber As Long, ByVal nNumerator As Long, ByVal nDenominator As Long) As Long
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long

Private Const LR_LOADFROMFILE       As Long = &H10
Private Const LR_CREATEDIBSECTION   As Long = &H2000
Private Const LR_LOADTRANSPARENT    As Long = &H20
Private Const IMAGE_BITMAP          As Long = 0

Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongW" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongW" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Const GWL_STYLE         As Long = (-16)
Private Const GWL_EXSTYLE       As Long = (-20)

Private Declare Function ShowWindow Lib "user32" (ByVal hwnd As Long, ByVal nCmdShow As Long) As Long
Private Const SW_SHOW  As Long = 5
Private Const GW_CHILD As Long = 5

Private Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Private Const SWP_NOMOVE        As Long = &H2
Private Const SWP_NOSIZE        As Long = &H1
Private Const SWP_NOOWNERZORDER As Long = &H200
Private Const SWP_NOZORDER      As Long = &H4
Private Const SWP_FRAMECHANGED  As Long = &H20

Private Const CCM_FIRST              As Long = &H2000
Private Const CCM_SETUNICODEFORMAT   As Long = (CCM_FIRST + 5)
Private Const CCM_GETUNICODEFORMAT   As Long = (CCM_FIRST + 6)

'= ListView =============================================================================

Private Const LVS_EX_GRIDLINES         As Long = &H1&
Private Const LVS_EX_SUBITEMIMAGES     As Long = &H2&
Private Const LVS_EX_CHECKBOXES        As Long = &H4&
Private Const LVS_EX_TRACKSELECT       As Long = &H8&
Private Const LVS_EX_HEADERDRAGDROP    As Long = &H10&
Private Const LVS_EX_FULLROWSELECT     As Long = &H20&
Private Const LVS_EX_ONECLICKACTIVATE  As Long = &H40&
Private Const LVS_EX_TWOCLICKACTIVATE  As Long = &H80&
Private Const LVS_EX_FLATSB            As Long = &H100&
Private Const LVS_EX_REGIONAL          As Long = &H200&
Private Const LVS_EX_INFOTIP           As Long = &H400&
Private Const LVS_EX_UNDERLINEHOT      As Long = &H800&
Private Const LVS_EX_UNDERLINECOLD     As Long = &H1000&
Private Const LVS_EX_MULTIWORKAREAS    As Long = &H2000&
Private Const LVS_EX_LABELTIP          As Long = &H4000&
Private Const LVS_EX_BORDERSELECT      As Long = &H8000&
Private Const LVS_EX_DOUBLEBUFFER      As Long = &H10000
Private Const LVS_EX_HIDELABELS        As Long = &H20000
Private Const LVS_EX_SINGLEROW         As Long = &H40000
Private Const LVS_EX_SNAPTOGRID        As Long = &H80000
Private Const LVS_EX_SIMPLESELECT      As Long = &H100000

Private Const LVS_ICON                 As Long = &H0
Private Const LVS_REPORT               As Long = &H1
Private Const LVS_SMALLICON            As Long = &H2
Private Const LVS_LIST                 As Long = &H3

Private Const LVS_ALIGNTOP             As Long = &H0
Private Const LVS_TYPEMASK             As Long = &H3
Private Const LVS_SINGLESEL            As Long = &H4
Private Const LVS_SHOWSELALWAYS        As Long = &H8
Private Const LVS_SORTASCENDING        As Long = &H10
Private Const LVS_SORTDESCENDING       As Long = &H20
Private Const LVS_SHAREIMAGELISTS      As Long = &H40
Private Const LVS_NOLABELWRAP          As Long = &H80
Private Const LVS_AUTOARRANGE          As Long = &H100
Private Const LVS_EDITLABELS           As Long = &H200
Private Const LVS_ALIGNLEFT            As Long = &H800
Private Const LVS_ALIGNMASK            As Long = &HC00
Private Const LVS_OWNERDATA            As Long = &H1000
Private Const LVS_NOSCROLL             As Long = &H2000
Private Const LVS_TYPESTYLEMASK        As Long = &HFC00
Private Const LVS_OWNERDRAWFIXED       As Long = &H400
Private Const LVS_NOCOLUMNHEADER       As Long = &H4000
Private Const LVS_NOSORTHEADER         As Long = &H8000

Private Const LVSCW_AUTOSIZE           As Long = -1
Private Const LVSCW_AUTOSIZE_USEHEADER As Long = -2

Private Const LV_VIEW_ICON             As Long = &H0&
Private Const LV_VIEW_DETAILS          As Long = &H1&
Private Const LV_VIEW_SMALLICON        As Long = &H2&
Private Const LV_VIEW_LIST             As Long = &H3&
Private Const LV_VIEW_TILE             As Long = &H4&

'//

Private Type LVITEM
    mask       As Long
    iItem      As Long
    iSubItem   As Long
    State      As Long
    stateMask  As Long
    pszText    As Long
    cchTextMax As Long
    iImage     As Long
    lParam     As Long
    iIndent    As Long
    iGroupId   As Long
    cColumns   As Long
    puColumns  As Long
End Type

Private Type LVFINDINFO
    Flags       As Long
    psz         As Long
    lParam      As Long
    pt          As POINTAPI
    vkDirection As Long
End Type


Private Const LVIR_ICON = 1
Private Const LVIR_LABEL = 2
Private Const LVIR_BOUNDS = 0

Private Const LVIF_TEXT           As Long = &H1
Private Const LVIF_IMAGE          As Long = &H2
Private Const LVIF_PARAM          As Long = &H4
Private Const LVIF_STATE          As Long = &H8
Private Const LVIF_INDENT         As Long = &H10
Private Const LVIF_GROUPID        As Long = &H100
Private Const LVIF_COLUMNS        As Long = &H200

Private Const LVIS_STATEIMAGEMASK As Long = &HF000
Private Const LVIS_FOCUSED        As Long = &H1
Private Const LVIS_SELECTED       As Long = &H2
Private Const LVIS_CUT            As Long = &H4
Private Const LVIS_DROPHILITED    As Long = &H8
Private Const LVIS_OVERLAYMASK    As Long = &HF00

Private Const LVFI_PARAM          As Long = &H1
Private Const LVFI_STRING         As Long = &H2
Private Const LVFI_PARTIAL        As Long = &H8
Private Const LVFI_WRAP           As Long = &H20
Private Const LVFI_NEARESTXY      As Long = &H40

'//

Private Type LVCOLUMN
    mask       As Long
    fmt        As Long
    cx         As Long
    pszText    As Long
    cchTextMax As Long
    iSubItem   As Long
    iImage     As Long
    iOrder     As Long
End Type

Private Const LVCF_FMT     As Long = &H1
Private Const LVCF_WIDTH   As Long = &H2
Private Const LVCF_TEXT    As Long = &H4
Private Const LVCF_SUBITEM As Long = &H8
Private Const LVCF_IMAGE   As Long = &H10
Private Const LVCF_ORDER   As Long = &H20

'//

Private Type HDTEXTFILTER
    pszText    As Long
    cchTextMax As Long
End Type

Private Type WINDOWPOS
    hwnd        As Long
    hwndAfter   As Long
    X           As Long
    Y           As Long
    cx          As Long
    cy          As Long
    Flags       As Long
End Type

Private Type HDLAYOUT
    prc         As Long
    pwpos       As Long
End Type

Private Type HDITEM
    mask       As Long
    cxy        As Long
    pszText    As Long
    hbm        As Long
    cchTextMax As Long
    fmt        As Long
    lParam     As Long
    iImage     As Long
    iOrder     As Long
    Type       As Long
    pvFilter   As Long
    'state      As Long
End Type

Private Const HDS_HORZ            As Long = &H0
Private Const HDS_BUTTONS         As Long = &H2
Private Const HDS_HOTTRACK        As Long = &H4
Private Const HDS_HIDDEN          As Long = &H8
Private Const HDS_DRAGDROP        As Long = &H40
Private Const HDS_FULLDRAG        As Long = &H80
Private Const HDS_FILTERBAR       As Long = &H100
Private Const HDS_CHECKBOXES      As Long = &H400

Private Const HDIS_FOCUSED        As Long = &H1

Private Const HDFT_ISSTRING       As Long = &H0 ' HD_ITEM.pvFilter points to a HD_TEXTFILTER
Private Const HDFT_ISNUMBER       As Long = &H1 ' HD_ITEM.pvFilter points to a INT
Private Const HDFT_ISDATE         As Long = &H2 ' HD_ITEM.pvFilter points to a DWORD (dos date)

Private Const HDFT_HASNOVALUE     As Long = &H8000 ' clear the filter, by setting this bit

Private Const HDF_LEFT            As Long = 0
Private Const HDF_RIGHT           As Long = 1
Private Const HDF_CENTER          As Long = 2
Private Const HDF_JUSTIFYMASK     As Long = &H3
Private Const HDF_RTLREADING      As Long = 4
Private Const HDF_IMAGE           As Long = &H800
Private Const HDF_OWNERDRAW       As Long = &H8000&
Private Const HDF_STRING          As Long = &H4000
Private Const HDF_BITMAP          As Long = &H2000
Private Const HDF_BITMAP_ON_RIGHT As Long = &H1000
Private Const HDF_CHECKBOX        As Long = &H40
Private Const HDF_CHECKED         As Long = &H80
Private Const HDF_FIXEDWIDTH      As Long = &H100 ' Can't resize the column; same as LVCFMT_FIXED_WIDTH
Private Const HDF_SPLITBUTTON     As Long = &H1000000 'Column is a split button; same as LVCFMT_SPLITBUTTON

Private Const HDF_SORTDOWN As Long = &H400
Private Const HDF_SORTUP As Long = &H200

'//

Private Type LVBKIMAGE
    ulFlags        As Long
    hbm            As Long
    pszImage       As String
    cchImageMax    As Long
    xOffsetPercent As Long
    yOffsetPercent As Long
End Type

Private Const LVBKIF_SOURCE_NONE     As Long = &H0
Private Const LVBKIF_SOURCE_HBITMAP  As Long = &H1
Private Const LVBKIF_SOURCE_URL      As Long = &H2
Private Const LVBKIF_SOURCE_MASK     As Long = &H3
Private Const LVBKIF_STYLE_NORMAL    As Long = &H0
Private Const LVBKIF_STYLE_TILE      As Long = &H10
Private Const LVBKIF_STYLE_MASK      As Long = &H10
Private Const LVBKIF_TYPE_WATERMARK  As Long = &H10000000
Private Const LVBKIF_FLAG_ALPHABLEND As Long = &H20000000

'//

Private Const WM_KILLFOCUS          As Long = &H8
Private Const WM_ERASEBKGND         As Long = &H14
Private Const WM_SYSCOLORCHANGE     As Long = &H15
Private Const WM_SETFOCUS           As Long = &H7
Private Const WM_MOUSEACTIVATE      As Long = &H21
Private Const WM_SETFONT            As Long = &H30
Private Const WM_GETFONT            As Long = &H31
Private Const WM_NOTIFY             As Long = &H4E
Private Const WM_PAINT              As Long = &HF
Private Const WM_KEYDOWN            As Long = &H100
Private Const WM_KEYUP              As Long = &H101
Private Const WM_CHAR               As Long = &H102
Private Const WM_VSCROLL            As Long = &H115
Private Const WM_MOUSEMOVE          As Long = &H200
Private Const WM_LBUTTONUP          As Long = &H202
Private Const WM_LBUTTONDOWN        As Long = &H201
Private Const WM_RBUTTONDOWN        As Long = &H204
Private Const WM_RBUTTONUP          As Long = &H205
Private Const WM_MBUTTONDOWN        As Long = &H207
Private Const WM_MBUTTONUP          As Long = &H208
'//
Private Const SB_LINEUP             As Long = &H0
Private Const SB_LINEDOWN           As Long = &H1
Private Const SB_PAGEUP             As Long = &H2
Private Const SB_PAGEDOWN           As Long = &H3
Private Const SB_THUMBPOSITION      As Long = &H4
Private Const SB_THUMBTRACK         As Long = &H5
Private Const SB_TOP                As Long = &H6
Private Const SB_BOTTOM             As Long = &H7
Private Const SB_ENDSCROLL          As Long = &H8
'//

Private Const LVM_FIRST                    As Long = &H1000
Private Const LVM_GETBKCOLOR               As Long = (LVM_FIRST + 0)
Private Const LVM_SETBKCOLOR               As Long = (LVM_FIRST + 1)
Private Const LVM_GETIMAGELIST             As Long = (LVM_FIRST + 2)
Private Const LVM_SETIMAGELIST             As Long = (LVM_FIRST + 3)
Private Const LVM_GETITEMCOUNT             As Long = (LVM_FIRST + 4)
Private Const LVM_GETITEM                  As Long = (LVM_FIRST + 5)
Private Const LVM_SETITEM                  As Long = (LVM_FIRST + 76) 'Unicode
Private Const LVM_INSERTITEM               As Long = (LVM_FIRST + 77) 'Unicode
Private Const LVM_DELETEITEM               As Long = (LVM_FIRST + 8)
Private Const LVM_DELETEALLITEMS           As Long = (LVM_FIRST + 9)
Private Const LVM_GETCALLBACKMASK          As Long = (LVM_FIRST + 10)
Private Const LVM_SETCALLBACKMASK          As Long = (LVM_FIRST + 11)
Private Const LVM_GETNEXTITEM              As Long = (LVM_FIRST + 12)
Private Const LVM_FINDITEM                 As Long = (LVM_FIRST + 13)
Private Const LVM_GETITEMRECT              As Long = (LVM_FIRST + 14)
Private Const LVM_GETITEMPOSITION          As Long = (LVM_FIRST + 16)
Private Const LVM_HITTEST                  As Long = (LVM_FIRST + 18)
Private Const LVM_ENSUREVISIBLE            As Long = (LVM_FIRST + 19)
Private Const LVM_SCROLL                   As Long = (LVM_FIRST + 20)
Private Const LVM_REDRAWITEMS              As Long = (LVM_FIRST + 21)
Private Const LVM_ARRANGE                  As Long = (LVM_FIRST + 22)
Private Const LVM_EDITLABEL                As Long = (LVM_FIRST + 23)
Private Const LVM_GETEDITCONTROL           As Long = (LVM_FIRST + 24)
Private Const LVM_GETCOLUMN                As Long = (LVM_FIRST + 95) 'Unicode
Private Const LVM_SETCOLUMN                As Long = (LVM_FIRST + 96) 'Unicode
Private Const LVM_INSERTCOLUMN             As Long = (LVM_FIRST + 97) 'Unicode
Private Const LVM_DELETECOLUMN             As Long = (LVM_FIRST + 28)
Private Const LVM_GETCOLUMNWIDTH           As Long = (LVM_FIRST + 29)
Private Const LVM_SETCOLUMNWIDTH           As Long = (LVM_FIRST + 30)
Private Const LVM_GETHEADER                As Long = (LVM_FIRST + 31)
Private Const LVM_GETTEXTCOLOR             As Long = (LVM_FIRST + 35)
Private Const LVM_SETTEXTCOLOR             As Long = (LVM_FIRST + 36)
Private Const LVM_GETTEXTBKCOLOR           As Long = (LVM_FIRST + 37)
Private Const LVM_SETTEXTBKCOLOR           As Long = (LVM_FIRST + 38)
Private Const LVM_GETTOPINDEX              As Long = (LVM_FIRST + 39)
Private Const LVM_GETCOUNTPERPAGE          As Long = (LVM_FIRST + 40)
Private Const LVM_UPDATE                   As Long = (LVM_FIRST + 42)
Private Const LVM_SETITEMSTATE             As Long = (LVM_FIRST + 43)
Private Const LVM_GETITEMSTATE             As Long = (LVM_FIRST + 44)
Private Const LVM_GETITEMTEXT              As Long = (LVM_FIRST + 115) 'Unicode
Private Const LVM_SETITEMTEXT              As Long = (LVM_FIRST + 116) 'Unicode
Private Const LVM_SORTITEMS                As Long = (LVM_FIRST + 48)
Private Const LVM_GETSELECTEDCOUNT         As Long = (LVM_FIRST + 50)
Private Const LVM_GETITEMSPACING           As Long = (LVM_FIRST + 51)
Private Const LVM_SETICONSPACING           As Long = (LVM_FIRST + 53)
Private Const LVM_SETEXTENDEDLISTVIEWSTYLE As Long = (LVM_FIRST + 54)
Private Const LVM_GETEXTENDEDLISTVIEWSTYLE As Long = (LVM_FIRST + 55)
Private Const LVM_GETSUBITEMRECT           As Long = (LVM_FIRST + 56)
Private Const LVM_SETHOTITEM               As Long = (LVM_FIRST + 60)
Private Const LVM_GETHOTITEM               As Long = (LVM_FIRST + 61)
Private Const LVM_SETHOTCURSOR             As Long = (LVM_FIRST + 62)
Private Const LVM_GETHOTCURSOR             As Long = (LVM_FIRST + 63)
Private Const LVM_GETSELECTIONMARK         As Long = (LVM_FIRST + 66)
Private Const LVM_SETSELECTIONMARK         As Long = (LVM_FIRST + 67)
Private Const LVM_SETBKIMAGE               As Long = (LVM_FIRST + 68)
Private Const LVM_GETBKIMAGE               As Long = (LVM_FIRST + 69)
Private Const LVM_SORTITEMSEX              As Long = (LVM_FIRST + 81)
Private Const LVM_SETVIEW                  As Long = (LVM_FIRST + 142)
Private Const LVM_GETVIEW                  As Long = (LVM_FIRST + 143)

' Groups
Private Const LVM_GETGROUPSTATE            As Long = (LVM_FIRST + 92)
Private Const LVM_GETFOCUSEDGROUP          As Long = (LVM_FIRST + 93)
Private Const LVM_GETGROUPRECT             As Long = (LVM_FIRST + 98)
Private Const LVM_SETSELECTEDCOLUMN        As Long = (LVM_FIRST + 140)
Private Const LVM_INSERTGROUP              As Long = (LVM_FIRST + 145)
Private Const LVM_SETGROUPINFO             As Long = (LVM_FIRST + 147)
Private Const LVM_GETGROUPINFO             As Long = (LVM_FIRST + 149)
Private Const LVM_REMOVEGROUP              As Long = (LVM_FIRST + 150)
Private Const LVM_MOVEGROUP                As Long = (LVM_FIRST + 151)
Private Const LVM_GETGROUPCOUNT            As Long = (LVM_FIRST + 152)
Private Const LVM_GETGROUPINFOBYINDEX      As Long = (LVM_FIRST + 153)
Private Const LVM_MOVEITEMTOGROUP          As Long = (LVM_FIRST + 154)
Private Const LVM_SETGROUPMETRICS          As Long = (LVM_FIRST + 155)
Private Const LVM_GETGROUPMETRICS          As Long = (LVM_FIRST + 156)
Private Const LVM_ENABLEGROUPVIEW          As Long = (LVM_FIRST + 157)
Private Const LVM_SORTGROUPS               As Long = (LVM_FIRST + 158)
Private Const LVM_INSERTGROUPSORTED        As Long = (LVM_FIRST + 159)
Private Const LVM_REMOVEALLGROUPS          As Long = (LVM_FIRST + 160)
Private Const LVM_HASGROUP                 As Long = (LVM_FIRST + 161)
Private Const LVM_ISGROUPVIEWENABLED       As Long = (LVM_FIRST + 175)

Private Const LVM_GETFOOTERRECT            As Long = (LVM_FIRST + 205)
Private Const LVM_GETFOOTERINFO            As Long = (LVM_FIRST + 206)
Private Const LVM_GETFOOTERITEMRECT        As Long = (LVM_FIRST + 207)
Private Const LVM_GETFOOTERITEM            As Long = (LVM_FIRST + 208)

Private Type LVFOOTERINFO
    mask        As Long
    pszText     As Long
    cchTextMax  As Long
    cItems      As Long
End Type

Private Type LVFOOTERITEM
    mask        As Long
    iItem       As Long
    pszText     As String
    cchTextMax  As Long
    State       As Long
    stateMask   As Long
End Type

' footer flags
Private Const LVFF_ITEMCOUNT               As Long = &H1

'footer item flags
Private Const LVFIF_TEXT                   As Long = &H1
Private Const LVFIF_STATE                  As Long = &H2

' footer item state
Private Const LVFIS_FOCUSED                As Long = &H1

Private Const LVGGR_GROUP                  As Long = 0 'Entire expanded group
Private Const LVGGR_HEADER                 As Long = 1 'Header only (collapsed group)
Private Const LVGGR_LABEL                  As Long = 2 'Label only
Private Const LVGGR_SUBSETLINK             As Long = 3 'subset link only

Private Const LVGMF_NONE                   As Long = 0
Private Const LVGMF_BORDERSIZE             As Long = 1
Private Const LVGMF_BORDERCOLOR            As Long = 2
Private Const LVGMF_TEXTCOLOR              As Long = 4

Private Const LVGF_NONE                    As Long = 0
Private Const LVGF_HEADER                  As Long = &H1
Private Const LVGF_FOOTER                  As Long = &H2
Private Const LVGF_STATE                   As Long = &H4
Private Const LVGF_ALIGN                   As Long = &H8
Private Const LVGF_GROUPID                 As Long = &H10
' If SO >= WinVista Then
Private Const LVGF_SUBTITLE                As Long = &H100
Private Const LVGF_TASK                    As Long = &H200
Private Const LVGF_DESCRIPTIONTOP          As Long = &H400
Private Const LVGF_DESCRIPTIONBOTTOM       As Long = &H800
Private Const LVGF_TITLEIMAGE              As Long = &H1000
Private Const LVGF_EXTENDEDIMAGE           As Long = &H2000
Private Const LVGF_ITEMS                   As Long = &H4000
Private Const LVGF_SUBSET                  As Long = &H8000
Private Const LVGF_SUBSETITEMS             As Long = &H10000  'readonly, cItems holds count of items in visible subset, iFirstItem is valid

Private Const LVGS_NORMAL                  As Long = &H0
Private Const LVGS_COLLAPSED               As Long = &H1
Private Const LVGS_HIDDEN                  As Long = &H2

' SO >= WinVista
Private Const LVGS_NOHEADER                As Long = &H4
Private Const LVGS_COLLAPSIBLE             As Long = &H8
Private Const LVGS_FOCUSED                 As Long = &H10
Private Const LVGS_SELECTED                As Long = &H20
Private Const LVGS_SUBSETED                As Long = &H40
Private Const LVGS_SUBSETLINKFOCUSED       As Long = &H80

Private Const LVGA_HEADER_LEFT             As Long = &H1
Private Const LVGA_HEADER_CENTER           As Long = &H2
Private Const LVGA_HEADER_RIGHT            As Long = &H4 ' Don't forget to validate exclusivity
' SO >= WinVista
Private Const LVGA_FOOTER_LEFT             As Long = &H8
Private Const LVGA_FOOTER_CENTER           As Long = &H10
Private Const LVGA_FOOTER_RIGHT            As Long = &H20 ' Don't forget to validate exclusivity

Private Type LVGROUP
    cbSize                  As Long
    mask                    As Long
    pszHeader               As Long
    cchHeader               As Long
    
    pszFooter               As Long
    cchFooter               As Long
    
    iGroupId                As Long
    
    stateMask               As Long
    State                   As Long
    uAlign                  As Long
' SO >= WinVista
    pszSubtitle            As Long
    cchSubtitle            As Long
    pszTask                As Long
    cchTask                As Long
    pszDescriptionTop      As Long
    cchDescriptionTop      As Long
    pszDescriptionBottom   As Long
    cchDescriptionBottom   As Long
    iTitleImage            As Long
    iExtendedImage         As Long
    iFirstItem             As Long     ' Read only
    cItems                 As Long     ' Read only
    pszSubsetTitle         As Long   ' NULL if group is not subset
    cchSubsetTitle         As Long
End Type

Private Type LVGROUPMETRICS
    cbSize      As Long
    mask        As Long
    Left        As Long
    Top         As Long
    Right       As Long
    Bottom      As Long
    crLeft      As Long
    crTop       As Long
    crRigth     As Long
    crBottom    As Long
    crHeader    As Long
    crFooter    As Long
End Type

'//

Private Const HDM_FIRST                    As Long = &H1200
Private Const HDM_GETITEMCOUNT             As Long = (HDM_FIRST + 0)
Private Const HDM_INSERTITEM               As Long = (HDM_FIRST + 1)
Private Const HDM_DELETEITEM               As Long = (HDM_FIRST + 2)
Private Const HDM_GETITEM                  As Long = (HDM_FIRST + 3)
Private Const HDM_SETITEM                  As Long = (HDM_FIRST + 12) 'Unicode
Private Const HDM_LAYOUT                   As Long = (HDM_FIRST + 5)
Private Const HDM_HITTEST                  As Long = (HDM_FIRST + 6)
Private Const HDM_GETITEMRECT              As Long = (HDM_FIRST + 7)
Private Const HDM_SETIMAGELIST             As Long = (HDM_FIRST + 8)
Private Const HDM_GETIMAGELIST             As Long = (HDM_FIRST + 9)
Private Const HDM_ORDERTOINDEX             As Long = (HDM_FIRST + 15)
Private Const HDM_SETFILTERCHANGETIMEOUT   As Long = (HDM_FIRST + 22)
Private Const HDM_GETITEMDROPDOWNRECT      As Long = (HDM_FIRST + 25)

'//

Private Type NMHDR
    hwndFrom As Long
    idfrom   As Long
    code     As Long
End Type

Private Const MAX_LINKID_TEXT = 48 * 2
Private Const L_MAX_URL_LENGTH = (2048 + 32 + 6) * 2

Private Type LITEM
    mask        As Long
    iLink       As Long
    State       As Long
    stateMask   As Long
    szID        As String * MAX_LINKID_TEXT
    szUrl       As String * L_MAX_URL_LENGTH
End Type

Private Const LVHN_COLLAPSED                  As Long = &H1
Private Const LVHN_DONTKNOW                   As Long = &H30
Private Const LVHN_SELECTED                   As Long = &H20

Private Type NMGROUPHEADER
    hdr         As NMHDR
    iGroup      As Long
    iActual     As Long
    iPrev       As Long
End Type

Private Type NMLISTVIEW
    hdr       As NMHDR
    iItem     As Long
    iSubItem  As Long
    uNewState As Long
    uOldState As Long
    uChanged  As Long
    ptAction  As POINTAPI
    lParam    As Long
End Type

Private Type NMLVDISPINFO
    hdr  As NMHDR
    item As LVITEM
End Type

Private Type NMLVKEYDOWN
    hdr    As NMHDR
    wVKey  As Integer
    flags1 As Integer
    flags2 As Integer
End Type

Private Type LVHITTESTINFO
    pt       As POINTAPI
    Flags    As Long
    iItem    As Long
    iSubItem As Long
    iGroup   As Long
End Type

Private Type NMHEADER
    hdr     As NMHDR
    iItem   As Long
    iButton As Long
    hbm     As Long
    ptrHDI  As Long
    HDI     As HDITEM
End Type

Private Type NMLVSCROLL
    hdr     As NMHDR
    dx      As Long
    dy      As Long
End Type

Private Type HDHITTESTINFO
    pt    As POINTAPI
    Flags As Long
    iItem As Long
End Type

Private Const NM_FIRST             As Long = 0
Private Const NM_CLICK             As Long = (NM_FIRST - 2)
Private Const NM_DBLCLK            As Long = (NM_FIRST - 3)
Private Const NM_RETURN            As Long = (NM_FIRST - 4)
Private Const NM_RCLICK            As Long = (NM_FIRST - 5)
Private Const NM_RDBLCLK           As Long = (NM_FIRST - 6)
Private Const NM_SETFOCUS          As Long = (NM_FIRST - 7)
Private Const NM_KILLFOCUS         As Long = (NM_FIRST - 8)
Private Const NM_CUSTOMDRAW        As Long = (NM_FIRST - 12)
Private Const NM_HOVER             As Long = (NM_FIRST - 13)

Private Const LVN_FIRST            As Long = -100
Private Const LVN_ITEMCHANGING     As Long = (LVN_FIRST - 0)
Private Const LVN_ITEMCHANGED      As Long = (LVN_FIRST - 1)
Private Const LVN_INSERTITEM       As Long = (LVN_FIRST - 2)
Private Const LVN_DELETEITEM       As Long = (LVN_FIRST - 3)
Private Const LVN_DELETEALLITEMS   As Long = (LVN_FIRST - 4)
Private Const LVN_BEGINLABELEDIT   As Long = (LVN_FIRST - 75) 'Unicode
Private Const LVN_ENDLABELEDIT     As Long = (LVN_FIRST - 76) 'Unicode
Private Const LVN_COLUMNCLICK      As Long = (LVN_FIRST - 8)
Private Const LVN_BEGINDRAG        As Long = (LVN_FIRST - 9)
Private Const LVN_BEGINRDRAG       As Long = (LVN_FIRST - 11)
Private Const LVN_COLUMNDROPDOWN   As Long = (LVN_FIRST - 64)
Private Const LVN_BEGINSCROLL      As Long = (LVN_FIRST - 80)
Private Const LVN_ENDSCROLL        As Long = (LVN_FIRST - 81)
Private Const LVN_LINKCLICK        As Long = (LVN_FIRST - 84)
Private Const LVN_GROUPHEADERCLICK As Long = (LVN_FIRST - 88)

Private Const LVNI_ALL             As Long = &H0
Private Const LVNI_FOCUSED         As Long = &H1
Private Const LVNI_SELECTED        As Long = &H2
Private Const LVNI_CUT             As Long = &H4
Private Const LVNI_DROPHILITED     As Long = &H8
Private Const LVNI_ABOVE           As Long = &H100
Private Const LVNI_BELOW           As Long = &H200
Private Const LVNI_TOLEFT          As Long = &H400
Private Const LVNI_TORIGHT         As Long = &H800

Private Const LVHT_NOWHERE         As Long = &H1
Private Const LVHT_ONITEMICON      As Long = &H2
Private Const LVHT_ONITEMLABEL     As Long = &H4
Private Const LVHT_ONITEMSTATEICON As Long = &H8
Private Const LVHT_ONITEM          As Long = (LVHT_ONITEMICON Or LVHT_ONITEMLABEL Or LVHT_ONITEMSTATEICON)
Private Const LVHT_ABOVE           As Long = &H8
Private Const LVHT_BELOW           As Long = &H10
Private Const LVHT_TORIGHT         As Long = &H20
Private Const LVHT_TOLEFT          As Long = &H40
Private Const LVHT_EX_GROUP_HEADER As Long = &H10000000
Private Const LVHT_EX_GROUP_FOOTER As Long = &H20000000
Private Const LVHT_EX_GROUP_COLLAPSE As Long = &H40000000
Private Const LVHT_EX_GROUP_BACKGROUND As Long = &H80000000
Private Const LVHT_EX_GROUP_STATEICON As Long = &H1000000
Private Const LVHT_EX_GROUP_SUBSETLINK As Long = &H2000000
Private Const LVHT_EX_GROUP = (LVHT_EX_GROUP_BACKGROUND Or LVHT_EX_GROUP_COLLAPSE Or _
                                LVHT_EX_GROUP_FOOTER Or LVHT_EX_GROUP_HEADER Or LVHT_EX_GROUP_STATEICON Or _
                                LVHT_EX_GROUP_SUBSETLINK)
Private Const LVHT_EX_ONCONTENTS As Long = &H4000000
Private Const LVHT_EX_FOOTER As Long = &H8000000

Private Const HDN_FIRST            As Long = -300
Private Const HDN_ITEMCHANGING     As Long = (HDN_FIRST - 20) 'Unicode
Private Const HDN_ITEMCLICK        As Long = (HDN_FIRST - 22) 'Unicode
Private Const HDN_ITEMDBLCLICK     As Long = (HDN_FIRST - 23) 'Unicode
Private Const HDN_DIVIDERDBLCLICK  As Long = (HDN_FIRST - 25) 'unicode
Private Const HDN_BEGINTRACK       As Long = (HDN_FIRST - 26) 'Unicode
Private Const HDN_ENDTRACK         As Long = (HDN_FIRST - 27) 'Unicode
Private Const HDN_TRACK            As Long = (HDN_FIRST - 28) 'Unicode
Private Const HDN_GETDISPINFO      As Long = (HDN_FIRST - 99)
Private Const HDN_BEGINDRAG        As Long = (HDN_FIRST - 10)
Private Const HDN_ENDDRAG          As Long = (HDN_FIRST - 11)
Private Const HDN_FILTERCHANGE     As Long = (HDN_FIRST - 12)
Private Const HDN_FILTERBTNCLICK   As Long = (HDN_FIRST - 13)
Private Const HDN_ITEMCHECK        As Long = (HDN_FIRST - 16) 'The name is invented, not found his real name
Private Const HDN_DROPDOWN         As Long = (HDN_FIRST - 18)

Private Const HHT_NOWHERE          As Long = &H1
Private Const HHT_ONHEADER         As Long = &H2
Private Const HHT_ONDIVIDER        As Long = &H4
Private Const HHT_ONDIVOPEN        As Long = &H8
Private Const HHT_ABOVE            As Long = &H100
Private Const HHT_BELOW            As Long = &H200
Private Const HHT_TORIGHT          As Long = &H400
Private Const HHT_TOLEFT           As Long = &H800

Private Const HDI_WIDTH            As Long = &H1
Private Const HDI_FILTER           As Long = &H100
Private Const HDI_HEIGHT           As Long = HDI_WIDTH
Private Const HDI_TEXT             As Long = &H2
Private Const HDI_FORMAT           As Long = &H4
Private Const HDI_LPARAM           As Long = &H8
Private Const HDI_BITMAP           As Long = &H10
Private Const HDI_IMAGE            As Long = &H20
Private Const HDI_DI_SETITEM       As Long = &H40
Private Const HDI_ORDER            As Long = &H80

'= Custom draw ==========================================================================

Private Type NMCUSTOMDRAW
    hdr         As NMHDR
    dwDrawStage As Long
    hDC         As Long
    rc          As RECT
    dwItemSpec  As Long
    uItemState  As Long
    lItemlParam As Long
End Type

Private Type NMLVCUSTOMDRAW
    nmcd      As NMCUSTOMDRAW
    clrText   As Long
    clrTextBk As Long
    iSubItem  As Long
End Type

'- Custom draw paint stages
Private Const CDDS_PREPAINT          As Long = &H1
Private Const CDDS_POSTPAINT         As Long = &H2
Private Const CDDS_PREERASE          As Long = &H3
Private Const CDDS_POSTERASE         As Long = &H4
Private Const CDDS_ITEM              As Long = &H10000
Private Const CDDS_SUBITEM           As Long = &H20000
Private Const CDDS_ITEMPREPAINT      As Long = (CDDS_ITEM Or CDDS_PREPAINT)
Private Const CDDS_ITEMPOSTPAINT     As Long = (CDDS_ITEM Or CDDS_POSTPAINT)
Private Const CDDS_ITEMPREERASE      As Long = (CDDS_ITEM Or CDDS_PREERASE)
Private Const CDDS_ITEMPOSTERASE     As Long = (CDDS_ITEM Or CDDS_POSTERASE)

'- Custom draw Item states
Private Const CDIS_SELECTED          As Long = &H1
Private Const CDIS_GRAYED            As Long = &H2
Private Const CDIS_DISABLED          As Long = &H4
Private Const CDIS_CHECKED           As Long = &H8
Private Const CDIS_FOCUS             As Long = &H10
Private Const CDIS_DEFAULT           As Long = &H20
Private Const CDIS_HOT               As Long = &H40
Private Const CDIS_MARKED            As Long = &H80
Private Const CDIS_INDETERMINATE     As Long = &H100

'- Custom draw return values
Private Const CDRF_DODEFAULT         As Long = &H0
Private Const CDRF_NEWFONT           As Long = &H2
Private Const CDRF_SKIPDEFAULT       As Long = &H4
Private Const CDRF_NOTIFYPOSTPAINT   As Long = &H10
Private Const CDRF_NOTIFYITEMDRAW    As Long = &H20
Private Const CDRF_NOTIFYPOSTERASE   As Long = &H40
Private Const CDRF_NOTIFYSUBITEMDRAW As Long = &H20

'= Progress Bar And Ranking =========================================================================
Private Declare Function DrawIconEx Lib "user32" (ByVal hDC As Long, ByVal xLeft As Long, ByVal yTop As Long, ByVal hIcon As Long, ByVal cxWidth As Long, ByVal cyWidth As Long, ByVal istepIfAniCur As Long, ByVal hbrFlickerFreeDraw As Long, ByVal diFlags As Long) As Long
Private Const DI_MASK = &H1
Private Const DI_IMAGE = &H2
Private Const DI_NORMAL = DI_MASK Or DI_IMAGE
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hDC As Long) As Long
Private Declare Function Rectangle Lib "gdi32" (ByVal hDC As Long, ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function CreateSolidBrush Lib "gdi32" (ByVal crColor As Long) As Long
Private Declare Function CreatePen Lib "gdi32" (ByVal nPenStyle As Long, ByVal nWidth As Long, ByVal crColor As Long) As Long
Private Declare Function FillRect Lib "user32" (ByVal hDC As Long, ByRef lpRect As RECT, ByVal hBrush As Long) As Long
Private Declare Function DrawText Lib "user32" Alias "DrawTextA" (ByVal hDC As Long, ByVal lpStr As String, ByVal nCount As Long, ByRef lpRect As RECT, ByVal wFormat As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hDC As Long, ByVal hObject As Long) As Long
Private Declare Function SetBkMode Lib "gdi32" (ByVal hDC As Long, ByVal nBkMode As Long) As Long
Private Declare Function SetRect Lib "user32" (ByRef lpRect As RECT, ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function EndPaint Lib "user32" (ByVal hwnd As Long, lpPaint As PAINTSTRUCT) As Long
Private Declare Function BeginPaint Lib "user32" (ByVal hwnd As Long, lpPaint As PAINTSTRUCT) As Long
Private Declare Function InvalidateRect Lib "user32" (ByVal hwnd As Long, ByRef lpRect As RECT, ByVal bErase As Long) As Long
Private Declare Function ValidateRect Lib "user32" (ByVal hwnd As Long, ByRef lpRect As RECT) As Long
Private Declare Function DrawThemeBackground Lib "UXTHEME" (ByVal hTheme As Long, ByVal lhDC As Long, ByVal iPartId As Long, ByVal iStateId As Long, pRect As RECT, pClipRect As RECT) As Long
Private Declare Function IsThemeActive Lib "UXTHEME" () As Boolean
Private Declare Function OpenThemeData Lib "UXTHEME" (ByVal hwnd As Long, ByVal pszClassList As Long) As Long
Private Declare Function CloseThemeData Lib "UXTHEME" (ByVal hTheme As Long) As Long
Private Declare Function SetTextColor Lib "gdi32" (ByVal hDC As Long, ByVal crColor As Long) As Long
Private Declare Function PtInRect Lib "user32" (lpRect As RECT, ByVal X As Long, ByVal Y As Long) As Long
'Private Declare Function RedrawWindow Lib "USER32" (ByVal hWnd As Long, ByRef lprcUpdate As Any, ByVal hrgnUpdate As Long, ByVal fuRedraw As Long) As Long
Private Type PAINTSTRUCT
    hDC                     As Long
    fErase                  As Long
    rcPaint                 As RECT
    fRestore                As Long
    fIncUpdate              As Long
    rgbReserved(1 To 32)    As Byte
End Type

Private Const DT_CENTER = &H1
Private Const DT_SINGLELINE         As Long = &H20
Private Const DT_VCENTER            As Long = &H4

Private Const TRANSPARENT           As Long = 1

'= Image list ===========================================================================

Private Declare Function ImageList_Create Lib "COMCTL32" (ByVal MinCx As Long, ByVal MinCy As Long, ByVal Flags As Long, ByVal cInitial As Long, ByVal cGrow As Long) As Long
Private Declare Function ImageList_Duplicate Lib "COMCTL32" (ByVal hImageList As Long) As Long
Private Declare Function ImageList_Add Lib "COMCTL32" (ByVal hImageList As Long, ByVal hBitmap As Long, ByVal hBitmapMask As Long) As Long
Private Declare Function ImageList_SetBkColor Lib "COMCTL32" (ByVal hImageList As Long, ByVal clrBk As Long) As Long
Private Declare Function ImageList_AddMasked Lib "COMCTL32" (ByVal hImageList As Long, ByVal hbmImage As Long, ByVal crMask As Long) As Long
Private Declare Function ImageList_AddIcon Lib "COMCTL32" (ByVal hImageList As Long, ByVal hIcon As Long) As Long
Private Declare Function ImageList_Destroy Lib "COMCTL32" (ByVal hImageList As Long) As Long
Private Declare Function ImageList_Draw Lib "COMCTL32" (ByVal hImageList As Long, ByVal lIndex As Long, ByVal hDC As Long, ByVal X As Long, ByVal Y As Long, ByVal fStyle As Long) As Long

Private Const LVSIL_NORMAL    As Long = 0
Private Const LVSIL_SMALL     As Long = 1
Private Const LVSIL_STATE     As Long = 2

Private Const ILD_NORMAL      As Long = 0&
Private Const ILD_TRANSPARENT As Long = 1&
Private Const ILD_BLEND25     As Long = 2&
Private Const ILD_SELECTED    As Long = 4&
Private Const ILD_FOCUS       As Long = 4&
Private Const ILD_MASK        As Long = &H10&
Private Const ILD_IMAGE       As Long = &H20&
Private Const ILD_ROP         As Long = &H40&
Private Const ILD_OVERLAYMASK As Long = 3840&

Private Const DST_COMPLEX     As Long = &H0&
Private Const DST_TEXT        As Long = &H1&
Private Const DST_PREFIXTEXT  As Long = &H2&
Private Const DST_ICON        As Long = &H3&
Private Const DST_BITMAP      As Long = &H4&

Private Const DSS_NORMAL      As Long = &H0&
Private Const DSS_UNION       As Long = &H10&
Private Const DSS_DISABLED    As Long = &H20&
Private Const DSS_MONO        As Long = &H80&
Private Const DSS_RIGHT       As Long = &H8000&

Private Const ILC_COLOR       As Long = &H0
Private Const ILC_MASK        As Long = &H1
Private Const ILC_COLOR4      As Long = &H4
Private Const ILC_COLOR8      As Long = &H8
Private Const ILC_COLOR16     As Long = &H10
Private Const ILC_COLOR24     As Long = &H18
Private Const ILC_COLOR32     As Long = &H20

'//

'-- Public enums.:

Public Enum eViewModeConstants
    [vmIcon] = LVS_ICON
    [vmSmallIcon] = LVS_SMALLICON
    [vmList] = LVS_LIST
    [vmDetails] = LVS_REPORT
End Enum

Public Enum eBorderStyleConstants
    [bsNone] = 0
    [bsThick] = 2
    [bsThin] = 1
End Enum

Public Enum eColumnAlignConstants
    [caLeft] = HDF_LEFT
    [caRight] = HDF_RIGHT
    [caCenter] = HDF_CENTER
End Enum

Public Enum eAlignConstants
    [aLeft] = 0
    [aRight] = 2
    [aCenter] = 1
End Enum

Public Enum eColumnAutosizeConstants
    [caItem] = LVSCW_AUTOSIZE
    [caHeader] = LVSCW_AUTOSIZE_USEHEADER
End Enum

Public Enum eCoincidenceConstants
    [cWholeWord] = LVFI_STRING
    [cPartial] = LVFI_PARTIAL
End Enum

Public Enum eStateConstants
    [sSelected] = LVNI_SELECTED
    [sFocused] = LVNI_FOCUSED
    [sGhosted] = LVNI_CUT
End Enum

Public Enum eSortOrderConstants
    [soDefault] = 0
    [soAscending] = 1
    [soDescending] = -1
End Enum

Public Enum eSortTypeConstants
    [stString] = 0
    [stStringSensitive] = 1
    [stNumeric] = 2
    [stDate] = 3
    [stCustom] = 4
End Enum

Public Enum eFilterType
    ftNoFilter = 0
    ftString = 1
    ftNumeric = 2
    ftDate = 3
End Enum

Public Enum eGroupHitTest
    ghtGroup = LVHT_EX_GROUP
    ghtHeader = LVHT_EX_GROUP_HEADER
    ghtFooter = LVHT_EX_GROUP_FOOTER
    ghtTitle = LVHT_EX_GROUP_SUBSETLINK
    ghtBackground = LVHT_EX_GROUP_BACKGROUND
End Enum


'-- Property variables:
Private m_BackgroundPicture    As Boolean
Private m_BorderStyle          As eBorderStyleConstants
Private m_CheckBoxes           As Boolean
Private m_EditLabels           As Boolean
Private m_FullRowSelect        As Boolean
Private m_GridLines            As Boolean
Private m_HeaderDragDrop       As Boolean
Private m_HeaderFixedWidth     As Boolean
Private m_HeaderFlat           As Boolean
Private m_HeaderHide           As Boolean
Private m_HideSelection        As Boolean
Private m_LabelTips            As Boolean
Private m_MultiSelect          As Boolean
Private m_OneClickActivate     As Boolean
Private m_ScrollBarFlat        As Boolean
Private m_SubItemImages        As Boolean
Private m_TrackSelect          As Boolean
Private m_UnderlineHot         As Boolean
Private m_ViewMode             As eViewModeConstants
'//
Private m_RaiseSubItemPrePaint As Boolean
'//

'-- Private constants:

Private Const WC_LISTVIEW  As String = "SysListView32"
 
'-- Private variables:

Private m_uLVFI             As LVFINDINFO
Private m_uLVI              As LVITEM
Private m_lColumn           As Long
Private m_PRECEDE           As Long
Private m_FOLLOW            As Long

' For Callbacks
Private m_cbSort            As Long

Private m_bRedraw          As Long
Private m_hModShell32      As Long
Private m_bInitialized     As Boolean
Private m_bFirstItem       As Boolean
Private m_bInCtrl          As Boolean
Private m_snxL             As Single
Private m_snyL             As Single
Private m_hListView        As Long
Private m_hHeader          As Long
Private m_hILSmall         As Long
Private m_hILLarge         As Long
Private m_hILHeader        As Long
Private m_hFont            As Long
Private m_SetSList         As Boolean
Private m_SetHList         As Boolean
Private m_SetLList         As Boolean
Private WithEvents m_oFont As StdFont
Attribute m_oFont.VB_VarHelpID = -1
Private m_IconSpacingDef   As Long
Private m_ExplorerTheme     As Integer

Private m_GroupCount        As Long
Private m_BackColor         As Long
Private m_BorderColor       As Long
Private m_FillColor         As Long
Private m_TextColor         As Long
Private m_TextVisible       As Boolean
Private m_UseWindowsTheme   As Boolean
Private m_SubItemProgress   As Long

Private m_rhImgList         As Long
Private m_rImages(2)        As Long
Private m_rColumn           As Long
Private m_rLocked           As Long
Private m_rLastIndex        As Long

Public Enum eRankingIconStates
    rStateNormal = 0
    rStateHover = 1
    rStateActive = 2
End Enum

Private hTheme                      As Long

'-- Event declarations:

Public Event Click()
Public Event DblClick()
Public Event ItemClick(item As Long)
Public Event ItemDblClick(item As Long)
Public Event ItemCheck(item As Long)
Public Event ColumnClick(Column As Long)
Public Event ColumnRightClick(Column As Long)
Public Event ColumnCheck(Column As Long, Value As Boolean)
Public Event KeyDown(KeyCode As Integer, Shift As Integer)
Public Event KeyPress(KeyAscii As Integer)
Public Event KeyUp(KeyCode As Integer, Shift As Integer)
Public Event MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
Public Event MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
Public Event MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
Public Event MouseEnter()
Public Event MouseLeave()
Public Event BeforeLabelEdit(Cancel As Integer)
Public Event AfterLabelEdit(Cancel As Integer, NewString As String)
Public Event CustomSort(ByVal Column As Long, Item1 As Long, Val1, Item2 As Long, Val2)
Public Event Resize()
'Public Event GroupChanged(ByVal group As Integer, ByVal IsCollapsed As Boolean, ByVal AllItemSelected As Boolean)
Public Event FilterButtonClicked(ByVal Column As Long, Cancel As Boolean)
Public Event FilterTimeout(ByVal Column As Long)
Public Event ColumnMenu(ByVal Column As Long, ByVal xMenu As Single, ByVal yMenu As Single)
Public Event Scroll(ByVal X As Long, ByVal Y As Long)
Public Event Vote(ByVal item As Long, Value As Integer)
'//
Public Event OnSubItemPrePaint(ByVal item As Long, ByVal SubItem As Long, TextBackColor As Long, TextForeColor As Long, Process As Boolean)
'//
'========================================================================================
' mIOLEInPlaceActiveObject Implementation
' Author:      Mike Gainer, Matt Curland and Bill Storage
'
' Requires:    OleGuids.tlb (in IDE only)
'
' Description:
' Allows you to replace the standard IOLEInPlaceActiveObject interface for a
' UserControl with a customisable one.  This allows you to take control
' of focus in VB controls.
'
' The code could be adapted to replace other UserControl OLE interfaces.
'
' ---------------------------------------------------------------------------------------
' Visit vbAccelerator, advanced, free source for VB programmers
' http://vbaccelerator.com
'========================================================================================
Private Type IPAOHookStruct
    lpVTable    As Long                    'VTable pointer
    IPAOReal    As Long 'IOleInPlaceActiveObject 'Un-AddRefed pointer for forwarding calls
    ThisPointer As Long
End Type
Private m_uIPAO         As IPAOHookStruct
Private Declare Function IsEqualGUID Lib "ole32" (iid1 As uuid, iid2 As uuid) As Long

Private Type OLEINPLACEFRAMEINFO
    cb              As Long
    fMDIApp         As Boolean
    hwndFrame       As Long
    haccel          As Long
    cAccelEntries   As Long
End Type

Private Type POINT
    X As Long
    Y As Long
End Type

Private Type Msg
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINT
End Type 'MSG

Private Const S_FALSE               As Long = 1
Private Const S_OK                  As Long = 0

Private IID_IOleInPlaceActiveObject As uuid
Private m_IPAOVTable(9)             As Long

'*************************************************************************************************
' ==== Used by CallInterface Function =====================================================

Private Type uuid
  Data1         As Long
  Data2         As Integer
  Data3         As Integer
  Data4(0 To 7) As Byte
End Type

Private Enum IUnknown_Exports
    [QueryInterface] = 0
    [AddRef] = 1
    [Release] = 2
End Enum

Private Enum IPAO_Exports
    [GetWindow] = 3
    [ContextSensitiveHelp] = 4
    [TranslateAccelerator] = 5
    [OnFrameWindowActivate] = 6
    [OnDocWindowActivate] = 7
    [ResizeBorder] = 8
    [EnableModeless] = 9
End Enum

Private Declare Function PutMem2 Lib "msvbvm60" (ByVal pWORDDst As Long, ByVal NewValue As Long) As Long
Private Declare Function PutMem4 Lib "msvbvm60" (ByVal pDWORDDst As Long, ByVal NewValue As Long) As Long
Private Declare Function GetMem4 Lib "msvbvm60" (ByVal pDWORDSrc As Long, ByVal pDWORDDst As Long) As Long
Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Private Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function IIDFromString Lib "ole32.dll" (ByVal lpsz As Long, lpiid As uuid) As Long

Private Const IID_IOleInPlaceActive     As String = "{00000117-0000-0000-C000-000000000046}"
Private Const IID_IOleObject            As String = "{00000112-0000-0000-C000-000000000046}"
Private Const IID_IOleInPlaceSite       As String = "{00000119-0000-0000-C000-000000000046}"
Private Const IID_IOleControlSite       As String = "{B196B289-BAB4-101A-B69C-00AA00341D07}"
Private ptrMe As Long

Private Const GMEM_FIXED As Long = &H0
Private Const asmPUSH_imm32 As Byte = &H68
Private Const asmRET_imm16 As Byte = &HC2
Private Const asmCALL_rel32 As Byte = &HE8

' === Subclassing ========================================================
' Subclasing by Paul Caton
Private z_scFunk            As Collection   'hWnd/thunk-address collection
Private z_hkFunk            As Collection   'hook/thunk-address collection
Private z_cbFunk            As Collection   'callback/thunk-address collection
Private Const IDX_INDEX     As Long = 2     'index of the subclassed hWnd OR hook type
Private Const IDX_PREVPROC  As Long = 9     'Thunk data index of the original WndProc
Private Const IDX_BTABLE    As Long = 11    'Thunk data index of the Before table for messages
Private Const IDX_ATABLE    As Long = 12    'Thunk data index of the After table for messages
Private Const IDX_CALLBACKORDINAL As Long = 36 ' Ubound(callback thunkdata)+1, index of the callback

' Declarations:
Private Declare Sub RtlMoveMemory Lib "kernel32" (ByVal Destination As Long, ByVal Source As Long, ByVal Length As Long)
Private Declare Function IsBadCodePtr Lib "kernel32" (ByVal lpfn As Long) As Long
Private Declare Function VirtualAlloc Lib "kernel32" (ByVal lpAddress As Long, ByVal dwSize As Long, ByVal flAllocationType As Long, ByVal flProtect As Long) As Long
Private Declare Function VirtualFree Lib "kernel32" (ByVal lpAddress As Long, ByVal dwSize As Long, ByVal dwFreeType As Long) As Long
Private Declare Function GetModuleHandleA Lib "kernel32" (ByVal lpModuleName As String) As Long
Private Declare Function GetModuleHandleW Lib "kernel32" (ByVal lpModuleName As Long) As Long
Private Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long
Private Enum eThunkType
    SubclassThunk = 0
    CallbackThunk = 2
End Enum

Private Enum eMsgWhen                                                   'When to callback
  MSG_BEFORE = 1                                                        'Callback before the original WndProc
  MSG_AFTER = 2                                                         'Callback after the original WndProc
  MSG_BEFORE_AFTER = MSG_BEFORE Or MSG_AFTER                            'Callback before and after the original WndProc
End Enum

Private Const IDX_PARM_USER As Long = 13    'Thunk data index of the User-defined callback parameter data index
Private Const IDX_UNICODE   As Long = 107   'Must be UBound(subclass thunkdata)+1; index for unicode support
Private Const MSG_ENTRIES   As Long = 32    'Number of msg table entries. Set to 1 if using ALL_MESSAGES for all subclassed windows

Private Enum eAllMessages
    ALL_MESSAGES = -1     'All messages will callback
End Enum

Private Declare Function CallWindowProcA Lib "user32" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function CallWindowProcW Lib "user32" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function GetCurrentProcessId Lib "kernel32" () As Long
Private Declare Function GetWindowThreadProcessId Lib "user32" (ByVal hwnd As Long, lpdwProcessId As Long) As Long
Private Declare Function IsWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function IsWindowUnicode Lib "user32.dll" (ByVal hwnd As Long) As Long
Private Declare Function SetWindowLongA Lib "user32" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function SetWindowLongW Lib "user32" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long

    
'========================================================================================
' Usercontrol
'========================================================================================
Private Sub UserControl_Initialize()
    m_hModShell32 = LoadLibraryA("shell32.dll") '(*)
    Call InitCommonControls
    Set m_oFont = New StdFont
    
    m_SubItemProgress = -1
    m_rColumn = -1
    ProgressBackColor = vbWhite
    ProgressBorderColor = vbBlack
    ProgressFillColor = vbGreen
    ProgressTextColor = vbBlack
    ProgressTextVisible = True
'(*) KBID 309366 (http://support.microsoft.com/default.aspx?scid=kb;en-us;309366)
'    From vbAccelerator
'    http://www.vbaccelerator.com/home/VB/Code/Libraries/XP_Visual_Styles/Preventing_Crashes_at_Shutdown/article.asp
End Sub

Private Sub UserControl_Terminate()
    If (m_bInitialized) Then
        Call pvDestroyImageListSmall
        Call pvDestroyImageListLarge
        Call pvDestroyImageListHeader
        Call pvDestroyFont
        Call pvDestroyListView
        Set m_oFont = Nothing
        Call ssc_Terminate
        Call scb_TerminateCallbacks
        Call FreeLibrary(m_hModShell32)
    End If
End Sub

Private Sub UserControl_GotFocus()
    If (m_hListView) Then Call SetFocus(m_hListView)
End Sub

Private Sub UserControl_Resize()
  Dim rctClient As RECT
    If (m_hListView) Then
        Call GetClientRect(UserControl.hwnd, rctClient)
        With rctClient
            Call SetWindowPos(m_hListView, 0, .Left, .Top, .Right - .Left, .Bottom - .Top, SWP_NOZORDER Or SWP_NOOWNERZORDER)
        End With
        RaiseEvent Resize
    End If
End Sub

'============================================================================================
'cLVRanking & ProgressBar ---------------------------------------------------------------------------------
'============================================================================================

Private Function DrawRanking(rc As RECT, hDC As Long, ranking As Long, item As Long)
    Dim J As Integer, a As Long
    Dim lX As Long, lY As Long

    'Dim hBrush As Long
    'hBrush = CreateSolidBrush(SendMessage(hwnd, LVM_GETBKCOLOR, 0&, 0&))
    'FillRect DC, Rec, hBrush
    'DeleteObject hBrush

    lY = (rc.Top + ((rc.Bottom - rc.Top) / 2) - (16 / 2))
    For J = 0 To 4
        lX = (rc.Left + 16 * J)
        If lX >= 0 And lY >= 0 Then
            If ranking > J Then
                If item = m_rLastIndex And Not m_rLocked Then
                    a = eRankingIconStates.rStateHover
                Else
                    a = eRankingIconStates.rStateActive
                End If
            Else
                a = eRankingIconStates.rStateNormal
            End If
            
            Call DrawIconEx(hDC, lX, lY, m_rImages(a), 0, 0, 0, 0, DI_NORMAL)
        End If
    Next J
End Function

Private Function DrawProgressTheme(hDC As Long, hwnd As Long, rtRect As RECT, Valor As Long) As Boolean
    On Error Resume Next
    Dim lResult     As Long
    Dim lWidth      As Long
    Dim Percent     As Long
    Dim valueRect   As RECT

    If m_UseWindowsTheme Then
        lResult = DrawThemeBackground(hTheme, hDC, 1, 0, rtRect, rtRect)
        If lResult Then
            Call CloseThemeData(hTheme)
            hTheme = 0
        Else
            lWidth = rtRect.Right - rtRect.Left - 4
            If lWidth > 0 Then
                Percent = (Valor * lWidth) / 100
                Call SetRect(valueRect, rtRect.Left + 3, rtRect.Top + 3, rtRect.Left + 1 + Percent, rtRect.Bottom - 3)
                lResult = DrawThemeBackground(hTheme, hDC, 3, 2, valueRect, valueRect)
            End If
        End If
    End If
    If hTheme = 0 Or Not m_UseWindowsTheme Then
        Dim hPen        As Long, OldhPen As Long
        Dim hBrush      As Long, OldhBrush As Long
        
        Dim bColor As Long
        hPen = CreatePen(0, 1, m_BorderColor)
        hBrush = CreateSolidBrush(m_BackColor)
        
        OldhPen = SelectObject(hDC, hPen)
        OldhBrush = SelectObject(hDC, hBrush)
        
        Call Rectangle(hDC, rtRect.Left, rtRect.Top, rtRect.Right, rtRect.Bottom)
        
        Call DeleteObject(SelectObject(hDC, OldhPen))
        Call DeleteObject(SelectObject(hDC, OldhBrush))
        
        lWidth = rtRect.Right - rtRect.Left - 2
        If lWidth > 0 Then
            Percent = (Valor * lWidth) / 100
            Call SetRect(valueRect, rtRect.Left + 1, rtRect.Top + 1, rtRect.Left + 1 + Percent, rtRect.Bottom - 1)
            
            hBrush = CreateSolidBrush(m_FillColor)
            OldhBrush = SelectObject(hDC, hBrush)
            Call FillRect(hDC, valueRect, hBrush)
            Call DeleteObject(SelectObject(hDC, OldhBrush))
        End If
    End If
    If m_TextVisible Then
        Dim sText As String
        sText = Valor & " %"
        Call SetTextColor(hDC, m_TextColor)
        Call DrawText(hDC, sText, Len(sText), rtRect, DT_SINGLELINE Or DT_CENTER Or DT_VCENTER)
    End If
End Function

Private Function GetItemRect(hwnd As Long, ByVal Index As Long) As RECT
    GetItemRect.Left = LVIR_BOUNDS
    Call SendMessage(hwnd, LVM_GETITEMRECT, Index, GetItemRect)
End Function

Private Function GetItemRec(hwnd As Long, ByVal Column As Long, ByVal Index As Long) As RECT
    GetItemRec.Top = Column
    GetItemRec.Left = LVIR_LABEL
    Call SendMessage(hwnd, LVM_GETSUBITEMRECT, Index, GetItemRec)
End Function

'========================================================================================
' Methods
'========================================================================================

Public Function Initialize() As Boolean
    If (m_bInitialized = False) Then
        Initialize = pvCreate()
        If m_hListView = 0 Then Exit Function
        Call pvSetExStyle(LVS_EX_DOUBLEBUFFER, 0)
    
        If ssc_Subclass(UserControl.hwnd) Then
            Call ssc_AddMsg(UserControl.hwnd, MSG_BEFORE, ALL_MESSAGES)
        End If
        If ssc_Subclass(m_hListView) Then
            Call ssc_AddMsg(m_hListView, MSG_BEFORE, ALL_MESSAGES)
        End If
        
        m_bInitialized = True
        hTheme = OpenThemeData(hwnd, StrPtr("Progress"))
        m_snxL = -1
        m_snyL = -1
        
        '-- Initialize IOLEInPlaceActiveObject
        Call pvInitIPAO
    End If
End Function

Public Function InitializeImageListSmall( _
                Optional ByVal ImageWidth As Integer = 16, _
                Optional ByVal ImageHeight As Integer = 16) As Boolean
    If (m_hListView) Then
        Call pvDestroyImageListSmall
        m_hILSmall = ImageList_Create(ImageWidth, ImageHeight, ILC_COLOR32 Or ILC_MASK, 0, 0)
        Call SendMessage(m_hListView, LVM_SETIMAGELIST, LVSIL_SMALL, ByVal m_hILSmall)
        
        InitializeImageListSmall = (m_hILSmall <> 0)
    End If
End Function

Public Function InitializeImageListLarge( _
                Optional ByVal ImageWidth As Integer = 32, _
                Optional ByVal ImageHeight As Integer = 32) As Boolean
    
    If (m_hListView) Then
    
        Call pvDestroyImageListLarge
        m_hILLarge = ImageList_Create(ImageWidth, ImageHeight, ILC_COLOR32 Or ILC_MASK, 0, 0)
        Call SendMessage(m_hListView, LVM_SETIMAGELIST, LVSIL_NORMAL, ByVal m_hILLarge)
        
        InitializeImageListLarge = (m_hILLarge <> 0)
    End If
End Function

Public Function InitializeImageListHeader( _
                Optional ByVal ImageWidth As Integer = 16, _
                Optional ByVal ImageHeight As Integer = 16) As Boolean
    
    If (m_hListView) Then
        Call pvDestroyImageListHeader
        m_hILHeader = ImageList_Create(ImageWidth, ImageHeight, ILC_COLOR32 Or ILC_MASK, 0, 0)
        
        InitializeImageListHeader = (m_hILHeader <> 0)
    End If
End Function
' //

Public Function ImageListSmall_AddBitmap( _
                ByVal hBitmap As Long, _
                Optional ByVal MaskColor As Long = CLR_NONE _
                ) As Long
    
    If (m_hILSmall) Then
    
        If (MaskColor <> CLR_NONE) Then
            ImageListSmall_AddBitmap = ImageList_AddMasked(m_hILSmall, hBitmap, MaskColor)
          Else
            ImageListSmall_AddBitmap = ImageList_Add(m_hILSmall, hBitmap, 0)
        End If
    End If
End Function

Public Function ImageListSmall_AddIcon(ByVal hIcon As Long) As Long
    If (m_hILSmall) Then
        ImageListSmall_AddIcon = ImageList_AddIcon(m_hILSmall, hIcon)
    End If
End Function

Public Function ImageListLarge_AddBitmap( _
                ByVal hBitmap As Long, _
                Optional ByVal MaskColor As Long = CLR_NONE _
                ) As Long
    
    If (m_hILLarge) Then
    
        If (MaskColor <> CLR_NONE) Then
            ImageListLarge_AddBitmap = ImageList_AddMasked(m_hILLarge, hBitmap, MaskColor)
          Else
            ImageListLarge_AddBitmap = ImageList_Add(m_hILLarge, hBitmap, 0)
        End If
    End If
End Function

Public Function ImageListLarge_AddIcon( _
                ByVal hIcon As Long _
                ) As Long
    
    If (m_hILLarge) Then
    
        ImageListLarge_AddIcon = ImageList_AddIcon(m_hILLarge, hIcon)
    End If
End Function

Public Function ImageListHeader_AddBitmap( _
                ByVal hBitmap As Long, _
                Optional ByVal MaskColor As Long = CLR_NONE _
                ) As Long
    
    If (m_hILHeader) Then
    
        If (MaskColor <> CLR_NONE) Then
            ImageListHeader_AddBitmap = ImageList_AddMasked(m_hILHeader, hBitmap, MaskColor)
          Else
            ImageListHeader_AddBitmap = ImageList_Add(m_hILHeader, hBitmap, 0)
        End If
    End If
End Function

Public Function ImageListHeader_AddIcon( _
                ByVal hIcon As Long _
                ) As Long
    
    If (m_hILHeader) Then
        ImageListHeader_AddIcon = ImageList_AddIcon(m_hILHeader, hIcon)
    End If
End Function

Public Function Clear() As Boolean
    If (m_hListView) Then
        Clear = CBool(SendMessage(m_hListView, LVM_DELETEALLITEMS, 0, ByVal 0))
    End If
End Function

Public Function SelectAll() As Boolean
    Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .stateMask = LVIS_SELECTED
            .State = True
            .mask = LVIF_STATE
        End With
        Call SendMessage(m_hListView, LVM_SETITEMSTATE, -1, uLVI)
    End If
End Function

Public Function DeSelectAll() As Boolean
    Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .stateMask = LVIS_SELECTED
            .State = False
            .mask = LVIF_STATE
        End With
        Call SendMessage(m_hListView, LVM_SETITEMSTATE, -1, uLVI)
    End If
End Function

Public Function GetSelectedItem() As Long
    If m_hListView Then
        If MultiSelect Then
            GetSelectedItem = SendMessage(m_hListView, LVM_GETSELECTIONMARK, 0&, ByVal 0&)
        Else
            Dim lFlags As Long
            lFlags = LVNI_SELECTED
            If GetFocus() = m_hListView Then lFlags = lFlags Or LVNI_FOCUSED
   
            GetSelectedItem = SendMessage(m_hListView, LVM_GETNEXTITEM, &HFFFF, ByVal lFlags)
        End If
    End If
End Function

Public Function GetSelectedNexItem(prev As Long) As Long
    If m_hListView Then
        Dim lFlags As Long
        lFlags = LVNI_SELECTED
        If GetFocus() = m_hListView Then lFlags = lFlags Or LVNI_FOCUSED
    
        GetSelectedNexItem = SendMessage(m_hListView, LVM_GETNEXTITEM, prev, ByVal lFlags)
    End If
End Function

Public Function BackgroundPictureSet(ByVal sFilePath As String, Optional ByVal Tile As Boolean = True) As Boolean
  Dim uLBI As LVBKIMAGE
  Dim lRet As Long
    If (m_hListView) Then
        With uLBI
            m_BackgroundPicture = sFilePath <> vbNullString
            If m_BackgroundPicture Then
                If Not Tile Then
                    .ulFlags = LVBKIF_TYPE_WATERMARK
                    lRet = LoadImage(App.hInstance, sFilePath, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE Or LR_CREATEDIBSECTION Or LR_LOADTRANSPARENT)
                    If lRet Then
                        .hbm = lRet
                        .xOffsetPercent = 1
                        .yOffsetPercent = 1
                    Else
                        BackgroundPictureSet = False
                        Exit Function
                    End If
                Else
                    .pszImage = sFilePath & vbNullChar
                    .cchImageMax = Len(sFilePath) + 1
                    .ulFlags = LVBKIF_SOURCE_URL Or LVBKIF_STYLE_TILE
                End If
                lRet = SendMessage(m_hListView, LVM_SETBKIMAGE, 0, uLBI)
                If (lRet) Then
                    Call SendMessage(m_hListView, LVM_SETTEXTBKCOLOR, 0, CLR_NONE)
                    BackgroundPictureSet = True
                End If
            Else
                .ulFlags = LVBKIF_SOURCE_NONE
                lRet = SendMessage(m_hListView, LVM_SETBKIMAGE, 0, uLBI)
                
                ''Thanks BY CHIP (Jonney Wu)!  seems to fix the clear backgroundimage bug
                .ulFlags = LVBKIF_TYPE_WATERMARK
                lRet = SendMessage(m_hListView, LVM_SETBKIMAGE, 0, uLBI)
                
                ' No, LVBKIF_SOURCE_NONE Or LVBKIF_TYPE_WATERMARK does not work togheter
                
                If (lRet) = 0 Then
                    Call SendMessage(m_hListView, LVM_SETTEXTBKCOLOR, 0, ByVal CLR_NONE)
                    BackgroundPictureSet = True
                End If
            End If
        End With
   End If
End Function

Public Function Sort( _
                Optional ByVal Column As Long = 0, _
                Optional ByVal SortOrder As eSortOrderConstants = [soAscending], _
                Optional ByVal SortType As eSortTypeConstants = [stString] _
                ) As Boolean
    If m_hListView Then
        If m_cbSort = 0 Then m_cbSort = scb_SetCallbackAddr(3, 2)
        Dim lRet As Long
  
        m_lColumn = Column
            
        Select Case SortOrder
            Case [soDefault]
                m_PRECEDE = 1
                m_FOLLOW = -1
                lRet = SendMessage(m_hListView, LVM_SORTITEMSEX, 100, ByVal m_cbSort)
            Case [soAscending], [soDescending]
                m_PRECEDE = SortOrder
                m_FOLLOW = -SortOrder
                Select Case SortType
                    Case [stString]
                        lRet = SendMessage(m_hListView, LVM_SORTITEMSEX, SortType, ByVal m_cbSort)
                    Case [stStringSensitive]
                        lRet = SendMessage(m_hListView, LVM_SORTITEMSEX, SortType, ByVal m_cbSort)
                    Case [stNumeric]
                        lRet = SendMessage(m_hListView, LVM_SORTITEMSEX, SortType, ByVal m_cbSort)
                    Case [stDate]
                        lRet = SendMessage(m_hListView, LVM_SORTITEMSEX, SortType, ByVal m_cbSort)
                    Case [stCustom]
                        lRet = SendMessage(m_hListView, LVM_SORTITEMSEX, SortType, ByVal m_cbSort)
                End Select
        End Select
        Sort = lRet
    End If
End Function

'//

Public Function ColumnSetFocus(ByVal Column As Long)
    If m_hListView Then Call SendMessage(m_hListView, LVM_SETSELECTEDCOLUMN, Column, ByVal 0)
End Function

Public Function ColumnAdd( _
                ByVal Column As Long, _
                ByVal Text As String, _
                ByVal Width As Integer, _
                Optional ByVal Align As eColumnAlignConstants = [caLeft], _
                Optional ByVal Icon As Long = -1 _
                ) As Boolean

  Dim uLVC   As LVCOLUMN
  Dim uHDI   As HDITEM
  Dim bFirst As Boolean
    If (m_hListView) Then
        bFirst = (Me.ColumnCount = 0)
        ColumnAdd = (SendMessage(m_hListView, LVM_INSERTCOLUMN, Column, uLVC) > -1)
        If (ColumnAdd) Then
            If (bFirst) Then
                m_hHeader = pvHeaderhWnd()
                Call SendMessage(m_hHeader, HDM_SETIMAGELIST, 0, m_hILHeader)
            End If
            With uHDI
                .pszText = StrPtr(Text + vbNullChar)
                .cchTextMax = Len(Text) + 1
                .cxy = Width
                .fmt = HDF_STRING Or Align * -(Column <> 0) Or HDF_BITMAP_ON_RIGHT
                .mask = HDI_TEXT Or HDI_WIDTH Or HDI_FORMAT
                If Icon > -1 Then
                    .iImage = Icon
                    .fmt = .fmt Or HDF_IMAGE
                    .mask = .mask Or HDI_IMAGE
                End If
            End With
            Call SendMessage(m_hHeader, HDM_SETITEM, Column, uHDI)
        End If
    End If
End Function

Public Function ColumnRemove(ByVal Column As Long) As Boolean
    If (m_hListView) Then
        ColumnRemove = SendMessage(m_hListView, LVM_DELETECOLUMN, Column, ByVal 0)
        If (Me.ColumnCount = 0) Then m_hHeader = 0
    End If
End Function

Public Function ColumnAutosize(ByVal Column As Long, _
                Optional ByVal AutosizeType As eColumnAutosizeConstants = [caItem]) As Boolean
    If (m_hListView) Then ColumnAutosize = SendMessage(m_hListView, LVM_SETCOLUMNWIDTH, Column, ByVal AutosizeType)
End Function

' =============================================================================
' Items Sections

Public Function ItemAdd(ByVal item As Long, ByVal Text As String, Optional ByVal Indent As Integer = 0, Optional ByVal Icon As Long = -1) As Boolean
    If (m_hListView) Then
        Dim uLV As LVITEM
        With uLV
            .iItem = item
            .lParam = item
            .pszText = StrPtr(Text & vbNullChar)
            .cchTextMax = Len(Text) + 1
            .iIndent = Indent
            If Icon <> -1 Then .iImage = Icon
            .mask = LVIF_TEXT Or LVIF_INDENT Or (LVIF_IMAGE And Icon <> -1) Or LVIF_PARAM
        End With
        ItemAdd = (SendMessage(m_hListView, LVM_INSERTITEM, 0, uLV) > -1)
        
        If (SendMessage(m_hListView, LVM_GETITEMCOUNT, 0, ByVal 0) = 1) Then
            m_bFirstItem = True: Me.ItemFocused(0) = True
          Else
            m_bFirstItem = False
        End If
    End If
End Function

Public Function ItemRemove(ByVal item As Long) As Boolean
    If (m_hListView) Then ItemRemove = SendMessage(m_hListView, LVM_DELETEITEM, item, ByVal 0)
End Function

Public Function ItemEnsureVisible(ByVal item As Long) As Boolean
    If (m_hListView) Then ItemEnsureVisible = SendMessage(m_hListView, LVM_ENSUREVISIBLE, item, ByVal 0)
End Function
 
Public Function ItemFindText(ByVal Text As String, Optional ByVal StartItem As Long = -1, _
    Optional ByVal Coincidence As eCoincidenceConstants = [cWholeWord], _
    Optional ByVal Warp As Boolean = False) As Long
    
    If (m_hListView) = 0 Then Exit Function
    
    Dim uLVFI As LVFINDINFO
    With uLVFI
        .psz = StrPtr(Text + vbNullChar)
        .Flags = Coincidence
        If Warp Then .Flags = .Flags Or LVFI_WRAP
    End With
    ItemFindText = SendMessage(m_hListView, LVM_FINDITEM, StartItem, uLVFI)
End Function

Public Function ItemFindState( _
                Optional ByVal StartItem As Long = -1, Optional ByVal State As eStateConstants = [sSelected] _
                ) As Long
    If (m_hListView) Then ItemFindState = SendMessage(m_hListView, LVM_GETNEXTITEM, StartItem, ByVal State)
End Function

Public Function ItemHitTest( _
                ByVal X As Single, _
                ByVal Y As Single _
                ) As Long
  Dim uLVHI As LVHITTESTINFO
    If (m_hListView) Then
        With uLVHI.pt
            .X = ScaleX(X, UserControl.ScaleMode, vbPixels)
            .Y = ScaleY(Y, UserControl.ScaleMode, vbPixels)
        End With
        ItemHitTest = SendMessage(m_hListView, LVM_HITTEST, 0, uLVHI)
    End If
End Function

Public Sub SetItemSpacing(ByVal X As Integer, ByVal Y As Integer)
    If m_hListView Then Call SendMessage(m_hListView, LVM_SETICONSPACING, 0, ByVal MakeDWord(X, Y))
End Sub

Public Function SubItemSet(ByVal item As Long, ByVal SubItem As Long, ByVal Text As String, Optional ByVal Icon As Long = -1) As Boolean
    If m_hListView = 0 Then Exit Function
    Dim uLV As LVITEM
    With uLV
        .iItem = item
        .iSubItem = SubItem
        .pszText = StrPtr(Text & vbNullChar)
        .cchTextMax = Len(Text) + 1
        If Icon > -1 Then .iImage = Icon
        .mask = LVIF_TEXT Or (LVIF_IMAGE And Icon > -1)
    End With
    SubItemSet = SendMessage(m_hListView, LVM_SETITEM, 0, uLV)
End Function

Public Sub Refresh()
    If m_hListView Then Call RedrawWindow(m_hListView, 0, 0, RDW_NOCHILDREN Or RDW_ERASE Or RDW_INVALIDATE Or RDW_VALIDATE)
End Sub

'========================================================================================
' Properties
'========================================================================================

' == ProgressBar Import =========================================================
Property Get ProgressColumn() As Long
    ProgressColumn = m_SubItemProgress
End Property
Property Let ProgressColumn(ByVal NewSubItemProgress As Long)
   m_SubItemProgress = NewSubItemProgress
End Property

Property Get ProgressBackColor() As OLE_COLOR
    ProgressBackColor = m_BackColor
End Property
Property Let ProgressBackColor(ByVal NewBackColor As OLE_COLOR)
    Call OleTranslateColor(NewBackColor, 0, m_BackColor)
End Property

Property Get ProgressBorderColor() As OLE_COLOR
    ProgressBorderColor = m_BorderColor
End Property
Property Let ProgressBorderColor(ByVal NewBorderColor As OLE_COLOR)
    Call OleTranslateColor(NewBorderColor, 0, m_BorderColor)
End Property

Property Get ProgressFillColor() As OLE_COLOR
    ProgressFillColor = m_FillColor
End Property
Property Let ProgressFillColor(ByVal NewFillColor As OLE_COLOR)
    Call OleTranslateColor(NewFillColor, 0, m_FillColor)
End Property

Property Get ProgressTextColor() As OLE_COLOR
    ProgressTextColor = m_TextColor
End Property
Property Let ProgressTextColor(ByVal NewTextColor As OLE_COLOR)
    Call OleTranslateColor(NewTextColor, 0, m_TextColor)
End Property

Property Get ProgressTextVisible() As Boolean
    ProgressTextVisible = m_TextVisible
End Property
Property Let ProgressTextVisible(ByVal Value As Boolean)
    m_TextVisible = Value
End Property

Property Get ProgressUseWindowsTheme() As Boolean
    ProgressUseWindowsTheme = m_UseWindowsTheme
End Property
Property Let ProgressUseWindowsTheme(ByVal Value As Boolean)
    If m_hListView <> 0 And Value And IsThemeActive Then
        If hTheme <> 0 Then Call CloseThemeData(hTheme)
        hTheme = OpenThemeData(m_hListView, StrPtr("Progress"))
    Else
        If hTheme Then
            Call CloseThemeData(hTheme)
            hTheme = 0
        End If
    End If
    m_UseWindowsTheme = Value
End Property

' =========================================================================
' ListView with Ranking
Public Property Get RankingLocked() As Boolean
    RankingLocked = m_rLocked
End Property
Public Property Let RankingLocked(Value As Boolean)
    m_rLocked = Value
End Property

Public Property Get RankingColumn() As Long
    RankingColumn = m_rColumn
End Property
Public Property Let RankingColumn(Value As Long)
    m_rColumn = Value
    Call Refresh
    Call SendMessage(m_hListView, LVM_SETCOLUMNWIDTH, Value, ByVal 16 * 5)
End Property

Public Property Get RankingIconHandle(State As eRankingIconStates) As Long
    RankingIconHandle = m_rImages(State)
End Property
Public Property Let RankingIconHandle(State As eRankingIconStates, Value As Long)
    m_rImages(State) = Value
End Property


Public Property Get NoRedraw() As Boolean
    NoRedraw = m_bRedraw
End Property
Public Property Let NoRedraw(Value As Boolean)
If m_hListView = 0 Then Exit Property
    m_bRedraw = Value
    Call SendMessage(m_hListView, WM_SETREDRAW, Not m_bRedraw, ByVal 0)
End Property


' =========================================================================

Public Property Get ColumnText(ByVal Column As Long) As String
Attribute ColumnText.VB_MemberFlags = "400"
If m_hListView = 0 Or m_hHeader = 0 Then Exit Property
    Dim uLVC  As LVCOLUMN
    Dim a     As String
    With uLVC
        a = String$(256, 0)
        .pszText = StrPtr(a)
        .cchTextMax = Len(a)
        .mask = LVCF_TEXT
    End With
    Call SendMessage(m_hListView, LVM_GETCOLUMN, Column, uLVC)
    ColumnText = Left$(a, uLVC.cchTextMax)
End Property
Public Property Let ColumnText(ByVal Column As Long, ByVal Text As String)
If m_hListView = 0 Or m_hHeader = 0 Then Exit Property
    Dim uLVC As LVCOLUMN
    With uLVC
        .pszText = StrPtr(Text & vbNullChar)
        .cchTextMax = Len(Text) + 1
        .mask = LVCF_TEXT
    End With
    Call SendMessage(m_hListView, LVM_SETCOLUMN, Column, uLVC)
End Property

Public Property Get ColumnWidth(ByVal Column As Long) As Integer
Attribute ColumnWidth.VB_MemberFlags = "400"
    If (m_hListView And m_hHeader) Then ColumnWidth = SendMessage(m_hListView, LVM_GETCOLUMNWIDTH, Column, ByVal 0)
End Property
Public Property Let ColumnWidth(ByVal Column As Long, ByVal Width As Integer)
    If (m_hListView And m_hHeader) Then
        If Column <> m_rColumn Then Call SendMessage(m_hListView, LVM_SETCOLUMNWIDTH, Column, ByVal Width)
    End If
End Property

Public Property Get ColumnAlign(ByVal Column As Long) As eColumnAlignConstants
If m_hListView = 0 Or m_hHeader = 0 Then Exit Property
  Const lMask As Long = &H3
    Dim uLVC    As LVCOLUMN
    With uLVC
        .mask = LVCF_FMT
        Call SendMessage(m_hListView, LVM_GETCOLUMN, Column, uLVC)
        ColumnAlign = (lMask And .fmt)
    End With
End Property
Public Property Let ColumnAlign(ByVal Column As Long, ByVal Align As eColumnAlignConstants)
If m_hListView = 0 Or m_hHeader = 0 Then Exit Property
    Dim uLVC As LVCOLUMN
    With uLVC
        .fmt = Align * -(Column <> 0)
        .mask = LVCF_FMT
    End With
    Call SendMessage(m_hListView, LVM_SETCOLUMN, Column, uLVC)
End Property

Public Property Get ColumnOrder(ByVal Column As Long) As eSortOrderConstants
If m_hListView = 0 Or m_hHeader = 0 Then Exit Property
    Dim uHDI   As HDITEM
    uHDI.mask = HDI_FORMAT
    Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
    If (HDF_SORTUP And uHDI.fmt) Then
        ColumnOrder = soDescending
    ElseIf (HDF_SORTDOWN And uHDI.fmt) Then
        ColumnOrder = soAscending
    Else
        ColumnOrder = soDefault
    End If
End Property
Public Property Let ColumnOrder(ByVal Column As Long, ByVal order As eSortOrderConstants)
If m_hListView = 0 Or m_hHeader = 0 Then Exit Property
    Dim uHDI   As HDITEM
    With uHDI
        .mask = HDI_FORMAT
        Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
        If order = soAscending Then
            .fmt = (.fmt And Not HDF_SORTUP) Or HDF_SORTDOWN
        ElseIf order = soDescending Then
            .fmt = (.fmt And Not HDF_SORTDOWN) Or HDF_SORTUP
        Else
            .fmt = .fmt And Not (HDF_SORTUP Or HDF_SORTDOWN)
        End If
    End With
    Call SendMessage(m_hHeader, HDM_SETITEM, Column, uHDI)
End Property

Public Property Get ColumnDropDown(ByVal Column As Long) As Boolean
If m_hListView = 0 Or m_hHeader = 0 Then Exit Property
'    Dim uHDI   As HDITEM
'    uHDI.mask = HDI_FORMAT
'    Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
'    ColumnDropDown = uHDI.fmt And HDF_SPLITBUTTON
    Dim uLVC As LVCOLUMN
    With uLVC
        .mask = LVCF_FMT
        Call SendMessage(m_hListView, LVM_GETCOLUMN, Column, uLVC)
        ColumnDropDown = uLVC.fmt And HDF_SPLITBUTTON
    End With
End Property
Public Property Let ColumnDropDown(ByVal Column As Long, ByVal Value As Boolean)
If m_hListView = 0 Or m_hHeader = 0 Then Exit Property
'    Dim uHDI   As HDITEM
'    uHDI.mask = HDI_FORMAT
'    Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
'    uHDI.fmt = (uHDI.fmt And Not HDF_SPLITBUTTON) Or (value And HDF_SPLITBUTTON)
'    Call SendMessage(m_hHeader, HDM_SETITEM, Column, uHDI)
    Dim uLVC As LVCOLUMN
    With uLVC
        .mask = LVCF_FMT
        Call SendMessage(m_hListView, LVM_GETCOLUMN, Column, uLVC)
        uLVC.fmt = (uLVC.fmt And Not HDF_SPLITBUTTON) Or (Value And HDF_SPLITBUTTON)
        Call SendMessage(m_hListView, LVM_SETCOLUMN, Column, uLVC)
    End With
End Property

Public Property Get ColumnFilters() As Boolean
    If m_hListView And m_hHeader Then ColumnFilters = GetWindowLong(m_hHeader, GWL_STYLE) And HDS_FILTERBAR
End Property
Public Property Let ColumnFilters(ByVal Value As Boolean)
If m_hListView = 0 Or m_hHeader = 0 Then Exit Property
If ColumnFilters = Value Then Exit Property
    Call SetWindowLong(m_hHeader, GWL_STYLE, GetWindowLong(m_hHeader, GWL_STYLE) And Not HDS_FILTERBAR Or (Value And HDS_FILTERBAR))
    Dim uHDL As HDLAYOUT
    Dim uRect As RECT
    Dim wRect As RECT
    Dim uWinPos As WINDOWPOS
    uHDL.prc = VarPtr(uRect)
    uHDL.pwpos = VarPtr(uWinPos)
    If SendMessage(m_hHeader, HDM_LAYOUT, 0, uHDL) <> 0 Then
        Call GetWindowRect(m_hHeader, wRect)
        With wRect
            Call SetWindowPos(m_hHeader, 0, .Left, .Top, .Right, uRect.Bottom, &H252)
        End With
    End If
    Dim i As Long
    For i = 0 To ColumnCount
        ColumnFilterType(i) = ftString
        Call ColumnFilterSetMaxLength(i, 255)
    Next
    If Count > 0 Then
        Call SendMessage(m_hListView, LVM_REDRAWITEMS, TopIndex, ByVal PageCount)
        Call SendMessage(m_hListView, LVM_UPDATE, TopIndex + PageCount, ByVal 0)
        Call SendMessage(m_hListView, LVM_REDRAWITEMS, TopIndex, ByVal PageCount)
    End If
End Property

Public Sub ColumnFilterSetMaxLength(ByVal Column As Long, ByVal MaxLength As Byte)
    Dim uHDI   As HDITEM
    Dim sValue As String
    Dim uValue As HDTEXTFILTER
    If (m_hListView And m_hHeader) Then
        With uHDI
            .mask = HDI_FILTER
            .Type = HDFT_HASNOVALUE
            Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
            If .Type = HDFT_ISSTRING Then
                .pvFilter = VarPtr(uValue)
                uValue.cchTextMax = 0
                sValue = String$(255, 0)
                uValue.pszText = StrPtr(sValue)
                Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
                uValue.cchTextMax = MaxLength
                Call SendMessage(m_hHeader, HDM_SETITEM, Column, uHDI)
            End If
        End With
    End If
End Sub

Public Sub ColumnFilterSetTimeOut(ByVal Value As Integer)
    If m_hHeader Then Call SendMessage(m_hHeader, HDM_SETFILTERCHANGETIMEOUT, 0, ByVal Value)
End Sub

Public Property Get ColumnFilterType(ByVal Column As Long) As eFilterType
    Dim uHDI   As HDITEM
    If (m_hListView And m_hHeader) Then
        With uHDI
            .mask = HDI_FILTER
            Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
            Select Case uHDI.Type
                Case HDFT_ISDATE: ColumnFilterType = ftDate
                Case HDFT_ISNUMBER: ColumnFilterType = ftNumeric
                Case Else: ColumnFilterType = ftString
            End Select
        End With
    End If
End Property
Public Property Let ColumnFilterType(ByVal Column As Long, ByVal Value As eFilterType)
    Dim uHDI   As HDITEM
    If (m_hListView And m_hHeader) Then
        With uHDI
            .mask = HDI_FILTER
            .Type = HDFT_HASNOVALUE
            Select Case Value
                Case eFilterType.ftString: .Type = HDFT_ISSTRING
                Case eFilterType.ftNumeric: .Type = HDFT_ISNUMBER
                Case eFilterType.ftDate: If pIsVista Then .Type = HDFT_ISDATE Else .Type = HDFT_ISSTRING
                'Case eFilterType.ftNoFilter: uHDI.type = HDFT_HASNOVALUE
            End Select
            Call SendMessage(m_hHeader, HDM_SETITEM, Column, uHDI)
            If .Type = HDFT_ISSTRING Then ColumnFilterText(Column) = vbNullString
        End With
    End If
End Property

Public Property Get ColumnFilterText(ByVal Column As Long) As String
    Dim uHDI   As HDITEM
    Dim uValue As HDTEXTFILTER
    Dim dValue As SYSTEMTIME
    Dim iValue As Long
    Dim bValue() As Byte
    Dim sValue As String
    If (m_hListView And m_hHeader) Then
        With uHDI
            .Type = HDFT_HASNOVALUE
            .mask = HDI_FILTER
            Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
            Select Case uHDI.Type
                Case HDFT_ISDATE
                    .pvFilter = VarPtr(dValue)
                    Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
                    ColumnFilterText = CStr(VBA.DateTime.DateSerial(dValue.wYear, dValue.wMonth, dValue.wDay))
                Case HDFT_ISNUMBER
                    .pvFilter = VarPtr(iValue)
                    Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
                    ColumnFilterText = iValue
                Case Else ' HDFT_ISSTRING
                    sValue = String$(255, 0)
                    uValue.pszText = StrPtr(sValue)
                    uValue.cchTextMax = 255
                    .pvFilter = VarPtr(uValue)
                    Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
                    ColumnFilterText = Trim$(Replace$(StrConv(sValue, vbUnicode), vbNullChar, vbNullString))
            End Select
        End With
    End If
End Property
Public Property Let ColumnFilterText(ByVal Column As Long, ByVal Value As String)
    Dim uHDI   As HDITEM
    Dim uValue As HDTEXTFILTER
    Dim dValue As SYSTEMTIME
    Dim iValue As Long
    Dim dDate As Date
    Dim sValue As String
    If (m_hListView And m_hHeader) Then
        With uHDI
            .mask = HDI_FILTER
            Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI)
            Select Case uHDI.Type
                Case HDFT_ISDATE
                    If Not IsDate(Value) Then Exit Property
                    dDate = CDate(Value)
                    dValue.wDay = day(dDate) + 1
                    dValue.wMonth = Month(dDate)
                    dValue.wYear = Year(dDate)
                    .pvFilter = VarPtr(dValue)
                Case HDFT_ISNUMBER
                    .pvFilter = VarPtr(CLng(Value))
'               Case HDFT_ISSTRING
                Case Else
                    .Type = HDFT_ISSTRING
                    uValue.pszText = StrPtr(StrConv(Value, vbFromUnicode))
                    .pvFilter = VarPtr(uValue)
                'Case Else: Exit Property
            End Select
            Call SendMessage(m_hHeader, HDM_SETITEM, Column, uHDI)
        End With
    End If
End Property

Public Property Get ColumnIcon(ByVal Column As Long) As Long
  Dim uLVC As LVCOLUMN
    If (m_hListView) Then
        With uLVC
            .mask = LVCF_IMAGE
        End With
        Call SendMessage(m_hListView, LVM_GETCOLUMN, Column, uLVC)
        ColumnIcon = uLVC.iImage
    End If
End Property
Public Property Let ColumnIcon(ByVal Column As Long, ByVal Icon As Long)
  Const lMask As Long = &H3
  Dim uHDI    As HDITEM
  Dim lAlign  As Long
    If (m_hListView And m_hHeader) Then
        With uHDI
            .mask = HDI_FORMAT
        Call SendMessage(m_hHeader, HDM_GETITEM, Column, uHDI): lAlign = lMask And .fmt
            .iImage = Icon
            .fmt = HDF_STRING Or lAlign Or HDF_IMAGE * -(Icon > -1 And m_hILHeader <> 0) Or HDF_BITMAP_ON_RIGHT
            .mask = HDI_IMAGE * -(Icon > -1) Or HDI_FORMAT
        End With
        Call SendMessage(m_hHeader, HDM_SETITEM, Column, uHDI)
    End If
End Property

Public Property Get ColumnCheckValue(ByVal Column As Long) As Boolean
    Dim uLVC As LVCOLUMN

    If (m_hListView And m_hHeader) Then
        With uLVC
            .mask = LVCF_FMT
            Call SendMessage(m_hListView, LVM_GETCOLUMN, Column, uLVC)
            ColumnCheckValue = uLVC.fmt And HDF_CHECKED
        End With
    End If
End Property
Public Property Let ColumnCheckValue(ByVal Column As Long, ByVal Value As Boolean)
    Dim uLVC As LVCOLUMN

    If (m_hListView And m_hHeader) Then
        With uLVC
            .mask = LVCF_FMT
            Call SendMessage(m_hListView, LVM_GETCOLUMN, Column, uLVC)
            uLVC.fmt = (uLVC.fmt And Not HDF_CHECKED) Or (Value And HDF_CHECKED)
            Call SendMessage(m_hListView, LVM_SETCOLUMN, Column, uLVC)
        End With
    End If

End Property

Public Property Get ColumnCheckStyle(ByVal Column As Long) As Boolean
    Dim uLVC As LVCOLUMN
    If (m_hListView And m_hHeader) Then
        With uLVC
            .mask = LVCF_FMT
            Call SendMessage(m_hListView, LVM_GETCOLUMN, Column, uLVC)
            ColumnCheckStyle = uLVC.fmt And HDF_CHECKBOX
        End With
    End If
End Property
Public Property Let ColumnCheckStyle(ByVal Column As Long, ByVal Value As Boolean)
    Dim uLVC As LVCOLUMN
    If (m_hListView And m_hHeader) Then
        With uLVC
            .mask = LVCF_FMT
            Call SendMessage(m_hListView, LVM_GETCOLUMN, Column, uLVC)
            uLVC.fmt = (uLVC.fmt And Not HDF_CHECKBOX) Or (Value And HDF_CHECKBOX)
            Call SendMessage(m_hListView, LVM_SETCOLUMN, Column, uLVC)
        End With
    End If
End Property

Public Property Get ColumnCheckBoxes() As Boolean
    If m_hListView And m_hHeader Then ColumnCheckBoxes = GetWindowLong(m_hHeader, GWL_STYLE) And HDS_CHECKBOXES
End Property

Public Property Let ColumnCheckBoxes(ByVal Value As Boolean)
    If m_hListView And m_hHeader Then
        Call SetWindowLong(m_hHeader, GWL_STYLE, GetWindowLong(m_hHeader, GWL_STYLE) And Not HDS_CHECKBOXES Or (Value And HDS_CHECKBOXES))
    End If
End Property

'//

Public Property Get ItemText(ByVal item As Long) As String
Attribute ItemText.VB_MemberFlags = "400"
  Dim uLVI   As LVITEM
  Dim a      As String
  Dim lLen   As Long
    If (m_hListView) Then
        With uLVI
            a = Space$(256)
            .pszText = StrPtr(a)
            .cchTextMax = Len(a)
        End With
        lLen = SendMessage(m_hListView, LVM_GETITEMTEXT, item, uLVI)
        ItemText = Left$(a, lLen)
    End If
End Property
Public Property Let ItemText(ByVal item As Long, ByVal Text As String)
    Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .pszText = StrPtr(Text & vbNullChar)
            .cchTextMax = Len(Text) + 1
        End With
        Call SendMessage(m_hListView, LVM_SETITEMTEXT, item, uLVI)
    End If
End Property

Public Property Get ItemGroup(ByVal item As Long) As Long
    If m_hListView Then
        Dim uLVI As LVITEM
        With uLVI
            .mask = LVIF_GROUPID
            .iItem = item
        End With
        If SendMessage(m_hListView, LVM_GETITEM, item, uLVI) Then ItemGroup = uLVI.iGroupId
    End If
End Property
Public Property Let ItemGroup(ByVal item As Long, ByVal Value As Long)
    If m_hListView Then
        Dim uLVI As LVITEM
        With uLVI
            .mask = LVIF_GROUPID
            .iItem = item
            .iGroupId = Value
        End With
        Call SendMessage(m_hListView, LVM_SETITEM, 0, uLVI)
    End If
End Property

Public Property Get ItemIcon(ByVal item As Long) As Long
Attribute ItemIcon.VB_MemberFlags = "400"
  Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .iItem = item
            .mask = LVIF_IMAGE
        End With
        Call SendMessage(m_hListView, LVM_GETITEM, 0, uLVI)
        ItemIcon = uLVI.iImage
    End If
End Property
Public Property Let ItemIcon(ByVal item As Long, ByVal Icon As Long)
  Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .iItem = item
            .iImage = Icon
            .mask = LVIF_IMAGE
        End With
        Call SendMessage(m_hListView, LVM_SETITEM, 0, uLVI)
    End If
End Property

Public Property Get ItemIndent(ByVal item As Long) As Integer
Attribute ItemIndent.VB_MemberFlags = "400"
  Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .iItem = item
            .mask = LVIF_INDENT
        End With
        Call SendMessage(m_hListView, LVM_GETITEM, 0, uLVI)
        ItemIndent = uLVI.iIndent
    End If
End Property
Public Property Let ItemIndent(ByVal item As Long, ByVal Indent As Integer)
  Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .iItem = item
            .iIndent = Indent
            .mask = LVIF_INDENT
        End With
        Call SendMessage(m_hListView, LVM_SETITEM, 0, uLVI)
    End If
End Property

Public Property Get ItemSelected(ByVal item As Long) As Boolean
Attribute ItemSelected.VB_MemberFlags = "400"
    If (m_hListView) Then
        ItemSelected = CBool(SendMessage(m_hListView, LVM_GETITEMSTATE, item, ByVal LVIS_SELECTED))
    End If
End Property
Public Property Let ItemSelected(ByVal item As Long, ByVal Selected As Boolean)
  Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .stateMask = LVIS_SELECTED Or -(Selected And item > -1) * LVIS_FOCUSED
            .State = -Selected * LVIS_SELECTED Or -(item > -1) * LVIS_FOCUSED
            .mask = LVIF_STATE
        End With
        Call SendMessage(m_hListView, LVM_SETITEMSTATE, item, uLVI)
    End If
End Property

Public Property Get ItemFocused(ByVal item As Long) As Boolean
Attribute ItemFocused.VB_MemberFlags = "400"
    If (m_hListView) Then
        ItemFocused = CBool(SendMessage(m_hListView, LVM_GETITEMSTATE, item, ByVal LVIS_FOCUSED))
    End If
End Property
Public Property Let ItemFocused(ByVal item As Long, ByVal Focused As Boolean)
    Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .stateMask = LVIS_FOCUSED
            .State = -Focused * LVIS_FOCUSED
            .mask = LVIF_STATE
        End With
        Call SendMessage(m_hListView, LVM_SETITEMSTATE, item, uLVI)
    End If
End Property

Public Property Get ItemChecked(ByVal item As Long) As Boolean
Attribute ItemChecked.VB_MemberFlags = "400"
    If (m_hListView) Then
        ItemChecked = ((SendMessage(m_hListView, LVM_GETITEMSTATE, item, ByVal LVIS_STATEIMAGEMASK) And &H2000&) = &H2000&)
    End If
End Property
Public Property Let ItemChecked(ByVal item As Long, ByVal Checked As Boolean)
  Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .stateMask = LVIS_STATEIMAGEMASK
            .State = &H1000& * (1 - Checked)
            .mask = LVIF_STATE
        End With
        Call SendMessage(m_hListView, LVM_SETITEMSTATE, item, uLVI)
    End If
End Property

Public Property Get ItemGhosted(ByVal item As Long) As Boolean
Attribute ItemGhosted.VB_MemberFlags = "400"
    If (m_hListView) Then
        ItemGhosted = (SendMessage(m_hListView, LVM_GETITEMSTATE, item, ByVal LVIS_CUT))
    End If
End Property
Public Property Let ItemGhosted(ByVal item As Long, ByVal Ghosted As Boolean)
    Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .stateMask = LVIS_CUT
            .State = LVIS_CUT * -Ghosted
            .mask = LVIF_STATE
        End With
        Call SendMessage(m_hListView, LVM_SETITEMSTATE, item, uLVI)
    End If
End Property

Public Property Get ItemSpacingX() As Integer
    If m_hListView Then ItemSpacingX = HiWord(m_IconSpacingDef)
End Property
Public Property Let ItemSpacingX(ByVal Value As Integer)
    If m_hListView Then
        m_IconSpacingDef = MakeDWord(LoWord(m_IconSpacingDef), Value)
        Call SendMessage(m_hListView, LVM_SETICONSPACING, 0, ByVal m_IconSpacingDef)
    End If
End Property
Public Property Get ItemSpacingY() As Integer
    If m_hListView Then ItemSpacingY = LoWord(m_IconSpacingDef)
End Property
Public Property Let ItemSpacingY(ByVal Value As Integer)
    If m_hListView Then
        m_IconSpacingDef = MakeDWord(Value, HiWord(m_IconSpacingDef))
        Call SendMessage(m_hListView, LVM_SETICONSPACING, 0, ByVal m_IconSpacingDef)
    End If
End Property

Public Property Get ItemLeft(ByVal Value As Long) As Single
    If m_hListView Then
        Dim pt As POINT
        Call SendMessage(m_hListView, LVM_GETITEMPOSITION, Value, pt)
        ItemLeft = ScaleX(pt.X, vbPixels, ScaleMode)
    End If
End Property

Public Property Get ItemTop(ByVal Value As Long) As Single
    If m_hListView Then
        Dim pt As POINT
        Call SendMessage(m_hListView, LVM_GETITEMPOSITION, Value, pt)
        ItemTop = ScaleY(pt.Y, vbPixels, ScaleMode)
    End If
End Property

Public Property Get ItemHeight(ByVal Value As Long) As Single
    If m_hListView Then
        Dim Rec As RECT
        Rec.Left = LVIR_BOUNDS
        Call SendMessage(m_hListView, LVM_GETITEMRECT, Value, Rec)
        ItemHeight = ScaleY(Rec.Right - Rec.Left, vbPixels, ScaleMode)
    End If
End Property

Public Property Get ItemWidth(ByVal Value As Long) As Single
    If m_hListView Then
        Dim Rec As RECT
        Rec.Left = LVIR_BOUNDS
        Call SendMessage(m_hListView, LVM_GETITEMRECT, Value, Rec)
        ItemWidth = ScaleX(Rec.Right - Rec.Left, vbPixels, ScaleMode)
    End If
End Property


'//

Public Property Get SubItemText(ByVal item As Long, ByVal SubItem As Long) As String
Attribute SubItemText.VB_MemberFlags = "400"
  Dim uLVI  As LVITEM
  Dim a     As String
  Dim lLen  As Long
    
    If (m_hListView) Then
        a = String$(256, 0)
        With uLVI
            .iSubItem = SubItem
            .pszText = StrPtr(a)
            .cchTextMax = Len(a)
            .mask = LVIF_TEXT
        End With
        lLen = SendMessage(m_hListView, LVM_GETITEMTEXT, item, uLVI)
        SubItemText = Left$(a, lLen) ' Left$(StrConv(a(), vbUnicode), lLen)
    End If
End Property
Public Property Let SubItemText(ByVal item As Long, ByVal SubItem As Long, ByVal Text As String)
  Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .iSubItem = SubItem
            .pszText = StrPtr(Text & vbNullChar)
            .cchTextMax = Len(Text) + 1
        End With
        Call SendMessage(m_hListView, LVM_SETITEMTEXT, item, uLVI)
    End If
End Property

Public Property Get SubItemIcon(ByVal item As Long, ByVal SubItem As Long) As Long
Attribute SubItemIcon.VB_MemberFlags = "400"
  Dim uLVI As LVITEM
    If (m_hListView) Then
        With uLVI
            .iItem = item
            .iSubItem = SubItem
            .mask = LVIF_IMAGE
        End With
        Call SendMessage(m_hListView, LVM_GETITEM, 0, uLVI)
        
        SubItemIcon = uLVI.iImage
    End If
End Property
Public Property Let SubItemIcon(ByVal item As Long, ByVal SubItem As Long, ByVal Icon As Long)
  
  Dim uLVI As LVITEM
    
    If (m_hListView) Then
            
        With uLVI
            .iItem = item
            .iSubItem = SubItem
            .iImage = Icon
            .mask = LVIF_IMAGE
        End With
        Call SendMessage(m_hListView, LVM_SETITEM, 0, uLVI)
    End If
End Property

Public Property Get SubItemLeft(ByVal item As Long, ByVal SubItem As Long) As Single
    If m_hListView Then
        Dim Rec As RECT
        Rec.Top = SubItem
        Rec.Left = LVIR_BOUNDS
        Call SendMessage(m_hListView, LVM_GETSUBITEMRECT, item, Rec)
        SubItemLeft = ScaleX(Rec.Left, vbPixels, ScaleMode)
    End If
End Property

Public Property Get SubItemTop(ByVal item As Long, ByVal SubItem As Long) As Single
    If m_hListView Then
        Dim Rec As RECT
        Rec.Top = SubItem
        Rec.Left = LVIR_BOUNDS
        Call SendMessage(m_hListView, LVM_GETSUBITEMRECT, item, Rec)
        SubItemTop = ScaleY(Rec.Top, vbPixels, ScaleMode)
    End If
End Property
Public Property Get SubItemWidth(ByVal item As Long, ByVal SubItem As Long) As Single
    If m_hListView Then
        Dim Rec As RECT
        Rec.Top = SubItem
        Rec.Left = LVIR_BOUNDS
        Call SendMessage(m_hListView, LVM_GETSUBITEMRECT, item, Rec)
        SubItemWidth = ScaleX(Rec.Right - Rec.Left, vbPixels, ScaleMode)
    End If
End Property
Public Property Get SubItemHeight(ByVal item As Long, ByVal SubItem As Long) As Single
    If m_hListView Then
        Dim Rec As RECT
        Rec.Top = SubItem
        Rec.Left = LVIR_BOUNDS
        Call SendMessage(m_hListView, LVM_GETSUBITEMRECT, item, Rec)
        SubItemHeight = ScaleY(Rec.Bottom - Rec.Top, vbPixels, ScaleMode)
    End If
End Property
'//

Public Property Get BackColor() As OLE_COLOR
Attribute BackColor.VB_MemberFlags = "400"
    If (m_hListView) Then BackColor = SendMessage(m_hListView, LVM_GETBKCOLOR, 0, ByVal 0)
End Property
Public Property Let BackColor(ByVal New_BackColor As OLE_COLOR)
If m_hListView = 0 Then Exit Property
    Dim lColor As Long
    Call OleTranslateColor(New_BackColor, 0, lColor)
    Call SendMessage(m_hListView, LVM_SETBKCOLOR, 0, ByVal lColor)
    Call SendMessage(m_hListView, LVM_SETTEXTBKCOLOR, 0, ByVal lColor)
    Call UserControl.Refresh
    Call PropertyChanged("BackColor")
End Property

Public Property Get BorderStyle() As eBorderStyleConstants
    BorderStyle = m_BorderStyle
End Property
Public Property Let BorderStyle(ByVal New_BorderStyle As eBorderStyleConstants)
    m_BorderStyle = New_BorderStyle
    Call pvSetBorderStyle(UserControl.hwnd, m_BorderStyle)
    Call UserControl_Resize
End Property

Public Property Get CheckBoxes() As Boolean
Attribute CheckBoxes.VB_MemberFlags = "400"
    CheckBoxes = m_CheckBoxes
End Property
Public Property Let CheckBoxes(ByVal New_CheckBoxes As Boolean)
    If (m_hListView) Then
        m_CheckBoxes = New_CheckBoxes
        If (m_CheckBoxes) Then
            Call pvSetExStyle(LVS_EX_CHECKBOXES, 0)
          Else
            Call pvSetExStyle(0, LVS_EX_CHECKBOXES)
        End If
    End If
End Property

Public Property Get Count() As Long
Attribute Count.VB_MemberFlags = "400"
    If (m_hListView) Then Count = SendMessage(m_hListView, LVM_GETITEMCOUNT, 0, ByVal 0)
End Property

Public Property Get ColumnCount() As Long
Attribute ColumnCount.VB_MemberFlags = "400"
    If (m_hListView) Then ColumnCount = SendMessage(pvHeaderhWnd(), HDM_GETITEMCOUNT, 0, ByVal 0)
End Property

Public Property Get Enabled() As Boolean
Attribute Enabled.VB_MemberFlags = "400"
    Enabled = UserControl.Enabled
End Property
Public Property Let Enabled(ByVal New_Enabled As Boolean)
    If (m_hListView) Then
        UserControl.Enabled = New_Enabled
        Call EnableWindow(m_hListView, New_Enabled)
    End If
End Property

Public Property Get ExplorerTheme() As Boolean
    ExplorerTheme = m_ExplorerTheme
End Property
Public Property Let ExplorerTheme(ByVal Value As Boolean)
    m_ExplorerTheme = Value
    If m_hListView Then
        If Value Then
            Call SetWindowTheme(m_hListView, StrPtr("explorer"), 0)
            Call SendMessage(m_hListView, LVM_SETCALLBACKMASK, LVIS_FOCUSED, ByVal 0)
        Else
            Call SetWindowTheme(m_hListView, 0, 0)
            Call SendMessage(m_hListView, LVM_SETCALLBACKMASK, 0, ByVal 0)
        End If
    End If
End Property

Public Property Get Font() As StdFont
Attribute Font.VB_MemberFlags = "400"
    Set Font = m_oFont
End Property
Public Property Set Font(ByVal New_Font As StdFont)

  Dim uLF   As LOGFONT
  Dim nChar As Integer

    If (m_hListView) Then
        Set m_oFont = New_Font
         With uLF
             For nChar = 1 To Len(m_oFont.Name)
                 .lfFaceName(nChar - 1) = CByte(Asc(Mid$(m_oFont.Name, nChar, 1)))
             Next nChar
             .lfHeight = -MulDiv(m_oFont.Size, GetDeviceCaps(hDC, LOGPIXELSY), 72)
             .lfItalic = m_oFont.Italic
             .lfWeight = IIf(m_oFont.Bold, FW_BOLD, FW_NORMAL)
             .lfUnderline = m_oFont.Underline
             .lfStrikeOut = m_oFont.Strikethrough
             .lfCharSet = m_oFont.Charset
        End With
        Call pvDestroyFont: m_hFont = CreateFontIndirect(uLF)
        
        Call SendMessage(m_hListView, WM_SETFONT, m_hFont, ByVal True)
    End If
End Property
Private Sub m_oFont_FontChanged(ByVal PropertyName As String)
    Set Font = m_oFont
End Sub

Public Property Get ForeColor() As OLE_COLOR
    If (m_hListView) Then
        ForeColor = SendMessage(m_hListView, LVM_GETTEXTCOLOR, 0, ByVal 0)
    End If
End Property
Public Property Let ForeColor(ByVal New_ForeColor As OLE_COLOR)
Attribute ForeColor.VB_MemberFlags = "400"
    
  Dim lColor As Long
    
    If (m_hListView) Then
        Call OleTranslateColor(New_ForeColor, 0, lColor)
        Call SendMessage(m_hListView, LVM_SETTEXTCOLOR, 0, ByVal lColor)
        Call UserControl.Refresh
    End If
End Property

Public Property Get FullRowSelect() As Boolean
Attribute FullRowSelect.VB_MemberFlags = "400"
    FullRowSelect = m_FullRowSelect
End Property
Public Property Let FullRowSelect(ByVal New_FullRowSelect As Boolean)
    If (m_hListView) Then
        m_FullRowSelect = New_FullRowSelect
        If (m_FullRowSelect) Then
            Call pvSetExStyle(LVS_EX_FULLROWSELECT, 0)
          Else
            Call pvSetExStyle(0, LVS_EX_FULLROWSELECT)
        End If
    End If
End Property

Public Property Get hwnd() As Long
    hwnd = m_hListView
End Property

Public Property Get GridLines() As Boolean
Attribute GridLines.VB_MemberFlags = "400"
    GridLines = m_GridLines
End Property
Public Property Let GridLines(ByVal New_GridLines As Boolean)
    If (m_hListView) Then
        m_GridLines = New_GridLines
        If (m_GridLines) Then
            Call pvSetExStyle(LVS_EX_GRIDLINES, 0)
          Else
            Call pvSetExStyle(0, LVS_EX_GRIDLINES)
        End If
    End If
End Property

Public Property Get HeaderDragDrop() As Boolean
Attribute HeaderDragDrop.VB_MemberFlags = "400"
    HeaderDragDrop = m_HeaderDragDrop
End Property
Public Property Let HeaderDragDrop(ByVal New_HeaderDragDrop As Boolean)
    If (m_hListView) Then
        m_HeaderDragDrop = New_HeaderDragDrop
        If (m_HeaderDragDrop) Then
            Call pvSetExStyle(LVS_EX_HEADERDRAGDROP, 0)
          Else
            Call pvSetExStyle(0, LVS_EX_HEADERDRAGDROP)
        End If
    End If
End Property

Public Property Get HeaderFixedWidth() As Boolean
Attribute HeaderFixedWidth.VB_MemberFlags = "400"
    HeaderFixedWidth = m_HeaderFixedWidth
End Property
Public Property Let HeaderFixedWidth(ByVal New_HeaderFixedWidth As Boolean)
    m_HeaderFixedWidth = New_HeaderFixedWidth
End Property

Public Property Get HeaderFlat() As Boolean
Attribute HeaderFlat.VB_MemberFlags = "400"
    HeaderFlat = m_HeaderFlat
End Property
Public Property Let HeaderFlat(ByVal New_HeaderFlat As Boolean)

  Dim lS    As Long
  Dim lhWnd As Long
  
    If (m_hListView) Then
        m_HeaderFlat = New_HeaderFlat
        lhWnd = pvHeaderhWnd()
        If (lhWnd) Then
            lS = GetWindowLong(lhWnd, GWL_STYLE)
            If (m_HeaderFlat) Then
                lS = lS And Not HDS_BUTTONS
              Else
                lS = lS Or HDS_BUTTONS
            End If
            Call SetWindowLong(lhWnd, GWL_STYLE, lS)
        End If
    End If
End Property

Public Property Get HeaderHide() As Boolean
Attribute HeaderHide.VB_MemberFlags = "400"
    HeaderHide = m_HeaderHide
End Property
Public Property Let HeaderHide(ByVal New_HeaderHide As Boolean)
    If (m_hListView) Then
        m_HeaderHide = New_HeaderHide
        If (m_HeaderHide) Then
            Call pvSetStyle(LVS_NOCOLUMNHEADER, 0)
          Else
            Call pvSetStyle(0, LVS_NOCOLUMNHEADER)
        End If
    End If
End Property

Public Property Get HideSelection() As Boolean
Attribute HideSelection.VB_MemberFlags = "400"
    HideSelection = m_HideSelection
End Property
Public Property Let HideSelection(ByVal New_HideSelection As Boolean)
    If (m_hListView) Then
        m_HideSelection = New_HideSelection
        If (m_HideSelection) Then
            Call pvSetStyle(0, LVS_SHOWSELALWAYS)
          Else
            Call pvSetStyle(LVS_SHOWSELALWAYS, 0)
        End If
    End If
End Property

Public Property Get LabelEdit() As Boolean
Attribute LabelEdit.VB_MemberFlags = "400"
    LabelEdit = m_EditLabels
End Property
Public Property Let LabelEdit(ByVal New_LabelEdit As Boolean)
    If (m_hListView) Then
        m_EditLabels = New_LabelEdit
        If (m_EditLabels) Then
            Call pvSetStyle(LVS_EDITLABELS, 0)
          Else
            Call pvSetStyle(0, LVS_EDITLABELS)
        End If
    End If
End Property

Public Property Get LabelTips() As Boolean
Attribute LabelTips.VB_MemberFlags = "400"
    LabelTips = m_LabelTips
End Property
Public Property Let LabelTips(ByVal New_LabelTips As Boolean)
    If (m_hListView) Then
        m_LabelTips = New_LabelTips
        If (m_LabelTips) Then
            Call pvSetExStyle(LVS_EX_LABELTIP, 0)
          Else
            Call pvSetExStyle(0, LVS_EX_LABELTIP)
        End If
    End If
End Property

Public Property Get MultiSelect() As Boolean
    MultiSelect = m_MultiSelect
End Property
Public Property Let MultiSelect(ByVal New_MultiSelect As Boolean)
Attribute MultiSelect.VB_MemberFlags = "400"
    If (m_hListView) Then
        m_MultiSelect = New_MultiSelect
        If (m_MultiSelect) Then
            Call pvSetStyle(0, LVS_SINGLESEL)
          Else
            Call pvSetStyle(LVS_SINGLESEL, 0)
        End If
    End If
End Property

Public Property Get OneClickActivate() As Boolean
Attribute OneClickActivate.VB_MemberFlags = "400"
    OneClickActivate = m_OneClickActivate
End Property
Public Property Let OneClickActivate(ByVal New_OneClickActivate As Boolean)
    If (m_hListView) Then
        m_OneClickActivate = New_OneClickActivate
        If (m_OneClickActivate) Then
            Call pvSetExStyle(LVS_EX_ONECLICKACTIVATE, 0)
          Else
            Call pvSetExStyle(0, LVS_EX_ONECLICKACTIVATE)
        End If
    End If
End Property

Public Property Get ScaleMode() As ScaleModeConstants
   ScaleMode = UserControl.ScaleMode
End Property
Public Property Let ScaleMode(ByVal New_ScaleMode As ScaleModeConstants)
   UserControl.ScaleMode = New_ScaleMode
End Property

Public Property Get ScrollBarFlat() As Boolean
Attribute ScrollBarFlat.VB_MemberFlags = "400"
    ScrollBarFlat = m_ScrollBarFlat
End Property
Public Property Let ScrollBarFlat(ByVal New_ScrollBarFlat As Boolean)
    If (m_hListView) Then
        m_ScrollBarFlat = New_ScrollBarFlat
        If (m_ScrollBarFlat) Then
            Call pvSetExStyle(LVS_EX_FLATSB, 0)
          Else
            Call pvSetExStyle(0, LVS_EX_FLATSB)
        End If
    End If
End Property

Public Property Get SelectedCount() As Long
Attribute SelectedCount.VB_MemberFlags = "400"
    If (m_hListView) Then
        SelectedCount = SendMessage(m_hListView, LVM_GETSELECTEDCOUNT, 0, ByVal 0)
    End If
End Property

Public Property Get SubItemImages() As Boolean
Attribute SubItemImages.VB_MemberFlags = "400"
    SubItemImages = m_SubItemImages
End Property
Public Property Let SubItemImages(ByVal New_SubItemImages As Boolean)
If m_hListView = 0 Then Exit Property
    m_SubItemImages = New_SubItemImages
    If m_SubItemImages Then Call pvSetExStyle(LVS_EX_SUBITEMIMAGES, 0) Else Call pvSetExStyle(0, LVS_EX_SUBITEMIMAGES)
End Property

Public Property Get TrackSelect() As Boolean
Attribute TrackSelect.VB_MemberFlags = "400"
    TrackSelect = m_TrackSelect
End Property
Public Property Let TrackSelect(ByVal New_TrackSelect As Boolean)
If m_hListView = 0 Then Exit Property
    m_TrackSelect = New_TrackSelect
    If m_TrackSelect Then Call pvSetExStyle(LVS_EX_TRACKSELECT, 0) Else Call pvSetExStyle(0, LVS_EX_TRACKSELECT)
End Property

Public Property Get TopIndex() As Long
    If m_hListView Then TopIndex = SendMessage(m_hListView, LVM_GETTOPINDEX, 0&, ByVal 0&)
End Property

Public Property Get PageCount() As Long
   If m_hListView Then PageCount = SendMessage(m_hListView, LVM_GETCOUNTPERPAGE, 0&, ByVal 0&)
End Property

Public Property Get UnderlineHot() As Boolean
Attribute UnderlineHot.VB_MemberFlags = "400"
    UnderlineHot = m_UnderlineHot
End Property
Public Property Let UnderlineHot(ByVal New_UnderlineHot As Boolean)
If m_hListView = 0 Then Exit Property
    m_UnderlineHot = New_UnderlineHot
    If m_UnderlineHot Then Call pvSetExStyle(LVS_EX_UNDERLINEHOT, 0) Else Call pvSetExStyle(0, LVS_EX_UNDERLINEHOT)
End Property

Public Property Let ViewMode(ByVal New_ViewMode As eViewModeConstants)
If m_hListView = 0 Then Exit Property
    m_ViewMode = New_ViewMode
    Call pvSetStyle(m_ViewMode, (LVS_ICON Or LVS_SMALLICON Or LVS_REPORT Or LVS_LIST))
    If m_ViewMode = vmIcon Then
        m_IconSpacingDef = SendMessage(m_hListView, LVM_SETICONSPACING, 0, ByVal MakeDWord(32, 32))
        Call SendMessage(m_hListView, LVM_SETICONSPACING, 0, ByVal m_IconSpacingDef)
    End If
End Property
Public Property Get ViewMode() As eViewModeConstants
Attribute ViewMode.VB_MemberFlags = "400"
    ViewMode = m_ViewMode
End Property

Public Property Get RaiseSubItemPrePaint() As Boolean
Attribute RaiseSubItemPrePaint.VB_MemberFlags = "400"
    RaiseSubItemPrePaint = m_RaiseSubItemPrePaint
End Property
Public Property Let RaiseSubItemPrePaint(ByVal New_RaiseSubItemPrePaint As Boolean)
    m_RaiseSubItemPrePaint = New_RaiseSubItemPrePaint
End Property


'*************************************************************************
' Groups
Public Function GroupAdd(ByVal id As Long, ByVal Caption As String, Optional ByVal Align As eAlignConstants = aLeft, _
        Optional ByVal Footer As String = vbNullString, Optional ByVal FooterAlign As eAlignConstants = aLeft) As Long
If m_hListView = 0 Then GroupAdd = -1: Exit Function
    Dim grupo As LVGROUP
    With grupo
        .mask = LVGF_HEADER Or LVGF_GROUPID Or LVGF_STATE Or LVGF_FOOTER Or LVGF_ALIGN
        .cbSize = Len(grupo)
        Caption = Caption & vbNullChar
        .pszHeader = StrPtr(Caption)
        .cchHeader = Len(Caption) + 1
        Footer = Footer & vbNullChar
        .pszFooter = StrPtr(Footer)
        .cchFooter = Len(Footer) + 1
        .State = LVGS_NORMAL
        .stateMask = 0&
        If Align = aCenter Then
            .uAlign = LVGA_HEADER_CENTER
        ElseIf Align = aRight Then
            .uAlign = LVGA_HEADER_RIGHT
        Else
            .uAlign = LVGA_HEADER_LEFT
        End If
        If pIsVista Then
            If FooterAlign = aCenter Then
                .uAlign = .uAlign Or LVGA_FOOTER_CENTER
            ElseIf FooterAlign = aRight Then
                .uAlign = .uAlign Or LVGA_FOOTER_RIGHT
            Else
                .uAlign = .uAlign Or LVGA_FOOTER_LEFT
            End If
        End If
        .iGroupId = id
    End With
    GroupAdd = SendMessage(m_hListView, LVM_INSERTGROUP, id, grupo)
    If GroupAdd <> -1 Then
        m_GroupCount = m_GroupCount + 1
        Call UpdateWindow(m_hListView)
    End If
End Function

Public Function GroupRemove(ByVal idGroup As Long) As Boolean
    If m_hListView Then GroupRemove = SendMessage(m_hListView, LVM_REMOVEGROUP, idGroup, ByVal 0&) <> -1
    If GroupRemove Then m_GroupCount = m_GroupCount - 1
End Function

Public Sub GroupClear()
If m_hListView = 0 Then Exit Sub
    Call SendMessage(m_hListView, LVM_REMOVEALLGROUPS, 0&, ByVal 0&)
    m_GroupCount = 0
End Sub

Public Property Get GroupGetFocused() As Long
    If m_hListView Then GroupGetFocused = SendMessage(m_hListView, LVM_GETFOCUSEDGROUP, 0, ByVal 0)
End Property

Public Property Get GroupsEnable() As Boolean
    If m_hListView Then GroupsEnable = SendMessage(m_hListView, LVM_ISGROUPVIEWENABLED, 0, ByVal 0)
End Property
Public Property Let GroupsEnable(enable As Boolean)
    If m_hListView Then Call SendMessage(m_hListView, LVM_ENABLEGROUPVIEW, enable, ByVal 0)
End Property

Public Property Get GroupHeaderText(ByVal idgrupo As Long) As String
    Dim s As String
    If m_hListView Then
        Dim grupo As LVGROUP
        With grupo
            .cbSize = Len(grupo)
            .mask = LVGF_HEADER
            If SendMessage(m_hListView, LVM_GETGROUPINFO, idgrupo, grupo) <> -1 Then
                .cchHeader = lstrlenW(.pszHeader)
                If .cchHeader > 0 Then
                    s = Space$(.cchHeader) & vbNullChar
                    Call lstrcpyW(StrPtr(s), .pszHeader)
                    GroupHeaderText = s
                End If
            End If
        End With
     End If
End Property
Public Property Let GroupHeaderText(ByVal idgrupo As Long, newText As String)
    If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_HEADER
        newText = newText & vbNullChar
        .pszHeader = StrPtr(newText)
        .cchHeader = Len(newText)
        If Not pIsVista Then
            ' XP Fix by chip
            .mask = .mask Or LVGF_GROUPID
            .iGroupId = -100
        End If
        Call SendMessage(m_hListView, LVM_SETGROUPINFO, idgrupo, grupo)
        If Not pIsVista Then
            .iGroupId = idgrupo
            Call SendMessage(m_hListView, LVM_SETGROUPINFO, -100, grupo)
        End If
    End With
    Call Refresh
End Property

' SO >= WinVista
Public Property Get GroupHeaderAlign(ByVal idgrupo As Long) As eAlignConstants
    If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    grupo.cbSize = Len(grupo)
    grupo.mask = LVGF_ALIGN
    If SendMessage(m_hListView, LVM_GETGROUPINFO, idgrupo, grupo) <> -1 Then
        If grupo.uAlign And LVGA_HEADER_LEFT Then
            GroupHeaderAlign = eAlignConstants.aLeft
        ElseIf grupo.uAlign And LVGA_HEADER_CENTER Then
            GroupHeaderAlign = eAlignConstants.aCenter
        ElseIf grupo.uAlign And LVGA_HEADER_RIGHT Then
            GroupHeaderAlign = eAlignConstants.aRight
        End If
    End If
End Property
Public Property Let GroupHeaderAlign(ByVal idgrupo As Long, ByVal newAlign As eAlignConstants)
    If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_ALIGN
        If SendMessage(m_hListView, LVM_GETGROUPINFO, idgrupo, grupo) <> -1 Then
            .uAlign = .uAlign And Not (LVGA_HEADER_CENTER Or LVGA_HEADER_LEFT Or LVGA_HEADER_RIGHT)
        End If
        If newAlign = aRight Then
            .uAlign = .uAlign Or LVGA_HEADER_RIGHT
        ElseIf newAlign = aCenter Then
            .uAlign = .uAlign Or LVGA_HEADER_CENTER
        Else
            .uAlign = .uAlign Or LVGA_HEADER_LEFT
        End If
    End With
    Call SendMessage(m_hListView, LVM_SETGROUPINFO, idgrupo, grupo)
End Property

Public Property Get GroupFooterText(ByVal idgrupo As Long) As String
If m_hListView = 0 Then Exit Property
    Dim s As String
    Dim grupo As LVGROUP
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_FOOTER
        s = Space$(256)
        .cchFooter = Len(s)
        .pszFooter = StrPtr(s)
    End With
    If SendMessage(m_hListView, LVM_GETGROUPINFO, idgrupo, grupo) <> -1 Then GroupFooterText = Trim$(s)
End Property
Public Property Let GroupFooterText(ByVal idgrupo As Long, newText As String)
    If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_FOOTER
        .pszFooter = StrPtr(newText)
        .cchFooter = Len(newText)
    End With
    Call SendMessage(m_hListView, LVM_SETGROUPINFO, idgrupo, grupo)
End Property

Public Property Get GroupSubtitle(ByVal idgrupo As Long) As String
If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    Dim s As String
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_SUBTITLE
        s = Space$(256)
        .cchSubtitle = Len(s)
        .pszSubtitle = StrPtr(s)
        If SendMessage(m_hListView, LVM_GETGROUPINFO, idgrupo, grupo) <> -1 Then
            GroupSubtitle = Left$(s, .pszSubsetTitle) 'Trim$(s)
        End If
    End With
End Property
Public Property Let GroupSubtitle(ByVal idgrupo As Long, ByVal Value As String)
If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_SUBTITLE
        .pszSubtitle = StrPtr(Value)
        .cchSubtitle = Len(Value)
    End With
    Call SendMessage(m_hListView, LVM_SETGROUPINFO, idgrupo, grupo)
End Property

Public Property Get GroupCollapsible(ByVal idgrupo As Long) As Boolean
    If m_hListView Then GroupCollapsible = SendMessage(m_hListView, LVM_GETGROUPSTATE, idgrupo, ByVal LVGS_COLLAPSIBLE)
End Property
Public Property Let GroupCollapsible(ByVal idgrupo As Long, ByVal Value As Boolean)
If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    Dim lState As Long
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_STATE
        .stateMask = LVGS_COLLAPSIBLE
        .State = LVGS_COLLAPSIBLE And Value
    End With
    Call SendMessage(m_hListView, LVM_SETGROUPINFO, idgrupo, grupo)
End Property

Public Property Get GroupCollapsed(ByVal idgrupo As Long) As Boolean
If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    Dim lState As Long
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_STATE
        .stateMask = LVGS_COLLAPSED
        Call SendMessage(m_hListView, LVM_GETGROUPINFO, idgrupo, grupo)
        GroupCollapsed = .State And LVGS_COLLAPSED
    End With
End Property
Public Property Let GroupCollapsed(ByVal idgrupo As Long, ByVal Value As Boolean)
If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    Dim lState As Long
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_STATE
        .stateMask = LVGS_COLLAPSED
        Call SendMessage(m_hListView, LVM_GETGROUPINFO, idgrupo, grupo)
        .State = (.State And Not LVGS_COLLAPSED) Or (Value And LVGS_COLLAPSED)
    End With
    Call SendMessage(m_hListView, LVM_SETGROUPINFO, idgrupo, grupo)
End Property

Public Property Get GroupFooterAlign(ByVal idgrupo As Long) As eAlignConstants
If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    grupo.cbSize = Len(grupo)
    grupo.mask = LVGF_ALIGN
    If SendMessage(m_hListView, LVM_GETGROUPINFO, idgrupo, grupo) <> -1 Then
        If grupo.uAlign And LVGA_FOOTER_LEFT Then
            GroupFooterAlign = aLeft
        ElseIf grupo.uAlign And LVGA_FOOTER_CENTER Then
            GroupFooterAlign = aCenter
        ElseIf grupo.uAlign And LVGA_FOOTER_RIGHT Then
            GroupFooterAlign = aRight
        End If
    End If
End Property
Public Property Let GroupFooterAlign(ByVal idgrupo As Long, ByVal newAlign As eAlignConstants)
If m_hListView = 0 Then Exit Property
    Dim grupo As LVGROUP
    With grupo
        .cbSize = Len(grupo)
        .mask = LVGF_ALIGN
        If SendMessage(m_hListView, LVM_GETGROUPINFO, idgrupo, grupo) <> -1 Then
           .uAlign = .uAlign And Not (LVGA_FOOTER_CENTER Or LVGA_FOOTER_LEFT Or LVGA_FOOTER_RIGHT)
        End If
        If newAlign = aRight Then
            .uAlign = .uAlign Or LVGA_FOOTER_RIGHT
        ElseIf newAlign = aCenter Then
            .uAlign = .uAlign Or LVGA_FOOTER_CENTER
        Else
            .uAlign = .uAlign Or LVGA_FOOTER_LEFT
        End If
    End With
    Call SendMessage(m_hListView, LVM_SETGROUPINFO, idgrupo, grupo)
End Property

Public Property Get GroupCount() As Long
If m_hListView = 0 Then Exit Property
    If pIsVista Then
        GroupCount = SendMessage(m_hListView, LVM_GETGROUPCOUNT, 0, ByVal 0)
    Else
        GroupCount = m_GroupCount
    End If
End Property

Public Function GroupHitTest(X As Single, Y As Single, Optional Options As eGroupHitTest = eGroupHitTest.ghtGroup) As Long
  Dim uLVHI As LVHITTESTINFO
    If (m_hListView) Then
        With uLVHI.pt
            .X = ScaleX(X, UserControl.ScaleMode, vbPixels)
            .Y = ScaleY(Y, UserControl.ScaleMode, vbPixels)
        End With
        uLVHI.Flags = Options
        GroupHitTest = SendMessage(m_hListView, LVM_HITTEST, -1, uLVHI)
        If uLVHI.Flags And LVHT_ONITEM Then
            If Options And ghtBackground Then
                GroupHitTest = ItemGroup(GroupHitTest)
            Else
                GroupHitTest = -1
            End If
        End If
    End If
End Function

'========================================================================================
' Private
'========================================================================================
Private Function LoWord(ByVal Numero As Long) As Long
    LoWord = Numero And &HFFFF&
End Function
Public Function HiWord(lDWord As Long) As Integer
  HiWord = (lDWord And &HFFFF0000) \ &H10000
End Function
Private Function LoByte(ByVal Numero As Integer) As Integer
    LoByte = Numero And &HFF
End Function

Public Function MakeDWord(ByVal LoWord As Integer, ByVal HiWord As Integer) As Long
  MakeDWord = (CLng(HiWord) * &H10000) Or (LoWord And &HFFFF&)
End Function

Private Function pIsVista() As Boolean
    pIsVista = LoByte(LoWord(GetVersion())) >= 6
End Function

Private Function pvCreate() As Boolean
  Dim lExStyle As Long
  Dim lLVStyle As Long
    Call pvDestroyListView
    
    lExStyle = GetWindowLong(UserControl.hwnd, GWL_EXSTYLE) And Not WS_EX_CLIENTEDGE
    lLVStyle = WS_CHILD Or WS_TABSTOP Or LVS_LIST Or LVS_AUTOARRANGE Or LVS_SINGLESEL Or LVS_SHOWSELALWAYS Or LVS_SHAREIMAGELISTS Or LVS_ALIGNTOP
    
    m_hListView = CreateWindowEx( _
                  lExStyle, StrPtr(WC_LISTVIEW), vbNullString, lLVStyle, _
                  0, 0, UserControl.ScaleWidth, UserControl.ScaleHeight, _
                  UserControl.hwnd, 0, App.hInstance, ByVal 0)
    
    If (m_hListView) Then
        Call SendMessage(m_hListView, CCM_SETUNICODEFORMAT, 1&, ByVal 0&)
        Call ShowWindow(m_hListView, SW_SHOW)
        pvCreate = True
    End If
End Function

Private Function pvDestroyListView() As Boolean
    If (m_hListView) Then
        If (DestroyWindow(m_hListView)) Then
            pvDestroyListView = True
            m_hListView = 0
        End If
    End If
End Function

Private Function pvDestroyImageListSmall() As Boolean
    If (m_hILSmall) Then
        If (ImageList_Destroy(m_hILSmall)) Then
            pvDestroyImageListSmall = True
            m_hILSmall = 0
        End If
    End If
End Function

Private Function pvDestroyImageListLarge() As Boolean
    If (m_hILLarge) Then
        If (ImageList_Destroy(m_hILLarge)) Then
            pvDestroyImageListLarge = True
            m_hILLarge = 0
        End If
    End If
End Function

Private Function pvDestroyImageListHeader() As Boolean
    If (m_hILHeader) Then
        If (ImageList_Destroy(m_hILHeader)) Then
            pvDestroyImageListHeader = True
            m_hILHeader = 0
        End If
    End If
End Function

Private Function pvDestroyFont() As Boolean
    If (m_hFont) Then
        If (DeleteObject(m_hFont)) Then
            pvDestroyFont = True
            m_hFont = 0
        End If
    End If
End Function

Private Function pvHeaderhWnd() As Long
    If (m_hListView) Then pvHeaderhWnd = SendMessage(m_hListView, LVM_GETHEADER, 0, ByVal 0)
End Function

Private Function pvEdithWnd() As Long
    If (m_hListView) Then pvEdithWnd = SendMessage(m_hListView, LVM_GETEDITCONTROL, 0, ByVal 0)
End Function

'//
Private Sub pvSetStyle(ByVal lStyle As Long, ByVal lStyleNot As Long)
  Dim lS As Long
    If (m_hListView) Then
        lS = GetWindowLong(m_hListView, GWL_STYLE)
        lS = lS And Not lStyleNot
        lS = lS Or lStyle
        Call SetWindowLong(m_hListView, GWL_STYLE, lS)
        Call SetWindowPos(m_hListView, 0, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE Or SWP_NOOWNERZORDER Or SWP_NOZORDER Or SWP_FRAMECHANGED)
   End If
End Sub

Private Sub pvSetExStyle(ByVal lStyle As Long, ByVal lStyleNot As Long)
  Dim lS As Long
    If (m_hListView) Then
        lS = SendMessage(m_hListView, LVM_GETEXTENDEDLISTVIEWSTYLE, 0, ByVal 0)
        lS = lS And Not lStyleNot
        lS = lS Or lStyle
        Call SendMessage(m_hListView, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, ByVal lS)
    End If
End Sub

Private Sub pvSetBorderStyle(ByVal lhWnd As Long, ByVal eStyle As eBorderStyleConstants)
    Select Case eStyle
        Case [bsNone]
            Call pvSetWinExStyle(lhWnd, GWL_STYLE, 0, WS_BORDER Or WS_THICKFRAME)
            Call pvSetWinExStyle(lhWnd, GWL_EXSTYLE, 0, WS_EX_STATICEDGE Or WS_EX_CLIENTEDGE Or WS_EX_WINDOWEDGE)
        Case [bsThin]
            Call pvSetWinExStyle(lhWnd, GWL_STYLE, 0, WS_BORDER Or WS_THICKFRAME)
            Call pvSetWinExStyle(lhWnd, GWL_EXSTYLE, WS_EX_STATICEDGE, WS_EX_CLIENTEDGE Or WS_EX_WINDOWEDGE)
        Case [bsThick]
            Call pvSetWinExStyle(lhWnd, GWL_STYLE, 0, WS_BORDER Or WS_THICKFRAME)
            Call pvSetWinExStyle(lhWnd, GWL_EXSTYLE, WS_EX_CLIENTEDGE, WS_EX_STATICEDGE Or WS_EX_WINDOWEDGE)
    End Select
End Sub

Private Sub pvSetWinExStyle(ByVal lhWnd As Long, ByVal lType As Long, ByVal lStyle As Long, ByVal lStyleNot As Long)
  Dim lS As Long
    lS = GetWindowLong(lhWnd, lType)
    lS = (lS And Not lStyleNot) Or lStyle
    Call SetWindowLong(lhWnd, lType, lS)
    Call SetWindowPos(lhWnd, 0, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE Or SWP_NOOWNERZORDER Or SWP_NOZORDER Or SWP_FRAMECHANGED)
End Sub

Private Function pvShiftState() As Integer
  Dim lS As Integer
    If (GetAsyncKeyState(vbKeyShift) < 0) Then lS = lS Or vbShiftMask
    If (GetAsyncKeyState(vbKeyMenu) < 0) Then lS = lS Or vbAltMask
    If (GetAsyncKeyState(vbKeyControl) < 0) Then lS = lS Or vbCtrlMask
    pvShiftState = lS
End Function

Private Function pvButton(ByVal uMsg As Long) As Integer
    Select Case uMsg
        Case WM_LBUTTONDOWN, WM_LBUTTONUP
            pvButton = vbLeftButton
        Case WM_RBUTTONDOWN, WM_RBUTTONUP
            pvButton = vbRightButton
        Case WM_MBUTTONDOWN, WM_MBUTTONUP
            pvButton = vbMiddleButton
        Case WM_MOUSEMOVE
            Select Case True
                Case GetAsyncKeyState(vbKeyLButton) < 0
                    pvButton = vbLeftButton
                Case GetAsyncKeyState(vbKeyRButton) < 0
                    pvButton = vbRightButton
                Case GetAsyncKeyState(vbKeyMButton) < 0
                    pvButton = vbMiddleButton
            End Select
    End Select
End Function

Private Sub pvUCCoordPixel(X As Long, Y As Long)
  Dim uPt As POINTAPI

    Call GetCursorPos(uPt)
    Call ScreenToClient(m_hListView, uPt)
    X = uPt.X
    Y = uPt.Y
End Sub

Private Sub pvUCCoordScale(X As Single, Y As Single)

  Dim uPt As POINTAPI

    Call GetCursorPos(uPt)
    Call ScreenToClient(m_hListView, uPt)
    X = ScaleX(uPt.X, vbPixels, UserControl.ScaleMode)
    Y = ScaleY(uPt.Y, vbPixels, UserControl.ScaleMode)
End Sub

Private Function pvItemHitTest() As Long
  Dim uLVHI As LVHITTESTINFO
   
    Call GetCursorPos(uLVHI.pt)
    Call ScreenToClient(m_hListView, uLVHI.pt)
    pvItemHitTest = SendMessage(m_hListView, LVM_HITTEST, 0, uLVHI)
End Function

Private Function pvSubItemHittest() As Long
    
End Function

'----------------------------------------------------------------------------------------
' Custom draw routine
'----------------------------------------------------------------------------------------

Private Function pvCustomDraw(ByVal lParam As Long) As Long
'   Customizing a Control's Appearance Using Custom Draw:
'   http://msdn.microsoft.com/library/default.asp?url=/library/en-us/shellcc/platform/commctls/custdraw/custdraw.asp
  
  Dim uNMLVCD   As NMLVCUSTOMDRAW
    Call RtlMoveMemory(VarPtr(uNMLVCD), lParam, Len(uNMLVCD))
    With uNMLVCD
        Select Case .nmcd.dwDrawStage
            Case CDDS_PREPAINT
                pvCustomDraw = CDRF_NOTIFYITEMDRAW
            Case CDDS_ITEMPREPAINT
                pvCustomDraw = CDRF_NOTIFYSUBITEMDRAW
            Case CDDS_SUBITEM Or CDDS_ITEMPREPAINT
                If RaiseSubItemPrePaint Then
                    Dim bProcess  As Boolean
                    Dim clrTextBk As OLE_COLOR
                    Dim clrText   As OLE_COLOR
                    RaiseEvent OnSubItemPrePaint(.nmcd.dwItemSpec, .iSubItem, clrTextBk, clrText, bProcess)
                    If (bProcess) Then
                        Call OleTranslateColor(clrTextBk, 0, .clrTextBk)
                        Call OleTranslateColor(clrText, 0, .clrText)
                        Call RtlMoveMemory(lParam, VarPtr(uNMLVCD), Len(uNMLVCD))
                    End If
                    pvCustomDraw = CDRF_DODEFAULT
                End If
                
                Dim itemvalue       As Long
                Dim itemrect        As RECT
                Dim progrect        As RECT
                
                If Not (ProgressColumn = -1 Or ViewMode <> vmDetails) And .iSubItem = m_SubItemProgress Then
                    itemrect = GetItemRec(m_hListView, m_SubItemProgress, uNMLVCD.nmcd.dwItemSpec)
                    Call SetRect(progrect, itemrect.Left + 1, itemrect.Top + 1, itemrect.Right - 1, itemrect.Bottom - 1)
                    
                    If m_SubItemProgress = 0 Then
                        itemvalue = Val(ItemText(.nmcd.dwItemSpec))
                    Else
                        itemvalue = Val(SubItemText(.nmcd.dwItemSpec, m_SubItemProgress))
                    End If
                    
                    If itemvalue < 0 Then itemvalue = 0
                    If itemvalue > 100 Then itemvalue = 100
                    Call DrawProgressTheme(uNMLVCD.nmcd.hDC, m_hListView, progrect, itemvalue)
                    pvCustomDraw = CDRF_SKIPDEFAULT
                End If
                If Not (RankingColumn = -1 Or ViewMode <> vmDetails) And .iSubItem = RankingColumn Then
                    itemrect = GetItemRec(m_hListView, m_rColumn, uNMLVCD.nmcd.dwItemSpec)
                    Call SetRect(progrect, itemrect.Left + 1, itemrect.Top + 1, itemrect.Right - 1, itemrect.Bottom - 1)
                    If m_rLastIndex <> .nmcd.dwItemSpec Then
                        If m_rColumn = 0 Then
                            itemvalue = Val(ItemText(.nmcd.dwItemSpec))
                        Else
                            itemvalue = Val(SubItemText(.nmcd.dwItemSpec, m_rColumn))
                        End If
                    Else
                        Dim snx As Long, sny As Long
                        Call pvUCCoordPixel(snx, sny)
                        itemvalue = Int((snx - .nmcd.rc.Left) / 16) + 1
                    End If
                    Call DrawRanking(progrect, .nmcd.hDC, itemvalue, .nmcd.dwItemSpec)
                    pvCustomDraw = CDRF_SKIPDEFAULT
                End If
        End Select
    End With
'(*) SubItem prepaint notification -> [Details] mode only.
'    For other view modes ('single-item'), process CDDS_ITEMPREPAINT draw stage.
End Function

'-SelfSub code------------------------------------------------------------------------------------
'-The following routines are exclusively for the ssc_Subclass routines----------------------------
Private Function ssc_Subclass(ByVal lng_hWnd As Long, _
                    Optional ByVal lParamUser As Long = 0, _
                    Optional ByVal nOrdinal As Long = 1, _
                    Optional ByVal oCallback As Object = Nothing, _
                    Optional ByVal bIdeSafety As Boolean = True, _
                    Optional ByRef bUnicode As Boolean = False, _
                    Optional ByVal bIsAPIwindow As Boolean = False) As Boolean 'Subclass the specified window handle

    '*************************************************************************************************
    '* lng_hWnd   - Handle of the window to subclass
    '* lParamUser - Optional, user-defined callback parameter
    '* nOrdinal   - Optional, ordinal index of the callback procedure. 1 = last private method, 2 = second last private method, etc.
    '* oCallback  - Optional, the object that will receive the callback. If undefined, callbacks are sent to this object's instance
    '* bIdeSafety - Optional, enable/disable IDE safety measures. There is not reason to set this to False
    '* bUnicode - Optional, if True, Unicode API calls should be made to the window vs ANSI calls
    '*            Parameter is byRef and its return value should be checked to know if ANSI to be used or not
    '* bIsAPIwindow - Optional, if True DestroyWindow will be called if IDE ENDs
    '*****************************************************************************************
    '** Subclass.asm - subclassing thunk
    '**
    '** Paul_Caton@hotmail.com
    '** Copyright free, use and abuse as you see fit.
    '**
    '** v2.0 Re-write by LaVolpe, based mostly on Paul Caton's original thunks....... 20070720
    '** .... Reorganized & provided following additional logic
    '** ....... Unsubclassing only occurs after thunk is no longer recursed
    '** ....... Flag used to bypass callbacks until unsubclassing can occur
    '** ....... Timer used as delay mechanism to free thunk memory afer unsubclassing occurs
    '** .............. Prevents crash when one window subclassed multiple times
    '** .............. More END safe, even if END occurs within the subclass procedure
    '** ....... Added ability to destroy API windows when IDE terminates
    '** ....... Added auto-unsubclass when WM_NCDESTROY received
    '*****************************************************************************************
    ' Subclassing procedure must be declared identical to the one at the end of this class (Sample at Ordinal #1)

    Dim z_Sc(0 To IDX_UNICODE) As Long                 'Thunk machine-code initialised here
    
    Const SUB_NAME      As String = "ssc_Subclass"     'This routine's name
    Const CODE_LEN      As Long = 4 * IDX_UNICODE + 4  'Thunk length in bytes
    Const PAGE_RWX      As Long = &H40&                'Allocate executable memory
    Const MEM_COMMIT    As Long = &H1000&              'Commit allocated memory
    Const MEM_RELEASE   As Long = &H8000&              'Release allocated memory flag
    Const GWL_WNDPROC   As Long = -4                   'SetWindowsLong WndProc index
    Const WNDPROC_OFF   As Long = &H60                 'Thunk offset to the WndProc execution address
    Const MEM_LEN       As Long = CODE_LEN + (8 * (MSG_ENTRIES + 1)) 'Bytes to allocate per thunk, data + code + msg tables
    
  ' This is the complete listing of thunk offset values and what they point/relate to.
  ' Those rem'd out are used elsewhere or are initialized in Declarations section
  
  'Const IDX_RECURSION  As Long = 0     'Thunk data index of callback recursion count
  'Const IDX_SHUTDOWN   As Long = 1     'Thunk data index of the termination flag
  'Const IDX_INDEX      As Long = 2     'Thunk data index of the subclassed hWnd
   Const IDX_EBMODE     As Long = 3     'Thunk data index of the EbMode function address
   Const IDX_CWP        As Long = 4     'Thunk data index of the CallWindowProc function address
   Const IDX_SWL        As Long = 5     'Thunk data index of the SetWindowsLong function address
   Const IDX_FREE       As Long = 6     'Thunk data index of the VirtualFree function address
   Const IDX_BADPTR     As Long = 7     'Thunk data index of the IsBadCodePtr function address
   Const IDX_OWNER      As Long = 8     'Thunk data index of the Owner object's vTable address
  'Const IDX_PREVPROC   As Long = 9     'Thunk data index of the original WndProc
   Const IDX_CALLBACK   As Long = 10    'Thunk data index of the callback method address
  'Const IDX_BTABLE     As Long = 11    'Thunk data index of the Before table
  'Const IDX_ATABLE     As Long = 12    'Thunk data index of the After table
  'Const IDX_PARM_USER  As Long = 13    'Thunk data index of the User-defined callback parameter data index
   Const IDX_DW         As Long = 14    'Thunk data index of the DestroyWinodw function address
   Const IDX_ST         As Long = 15    'Thunk data index of the SetTimer function address
   Const IDX_KT         As Long = 16    'Thunk data index of the KillTimer function address
   Const IDX_EBX_TMR    As Long = 20    'Thunk code patch index of the thunk data for the delay timer
   Const IDX_EBX        As Long = 26    'Thunk code patch index of the thunk data
  'Const IDX_UNICODE    As Long = xx    'Must be UBound(subclass thunkdata)+1; index for unicode support
    
    Dim z_ScMem       As Long           'Thunk base address
    Dim nAddr         As Long
    Dim nID           As Long
    Dim nMyID         As Long
    Dim bIDE          As Boolean

    If IsWindow(lng_hWnd) = 0 Then      'Ensure the window handle is valid
        Call zError(SUB_NAME, "Invalid window handle")
        Exit Function
    End If
    
    nMyID = GetCurrentProcessId                         'Get this process's ID
    GetWindowThreadProcessId lng_hWnd, nID              'Get the process ID associated with the window handle
    If nID <> nMyID Then                                'Ensure that the window handle doesn't belong to another process
        Call zError(SUB_NAME, "Window handle belongs to another process")
        Exit Function
    End If
    
    If oCallback Is Nothing Then Set oCallback = Me     'If the user hasn't specified the callback owner
    
    nAddr = zAddressOf(oCallback, nOrdinal)             'Get the address of the specified ordinal method
    If nAddr = 0 Then                                   'Ensure that we've found the ordinal method
        Call zError(SUB_NAME, "Callback method not found")
        Exit Function
    End If
        
    z_ScMem = VirtualAlloc(0, MEM_LEN, MEM_COMMIT, PAGE_RWX) 'Allocate executable memory
    
    If z_ScMem <> 0 Then                                'Ensure the allocation succeeded
    
      If z_scFunk Is Nothing Then Set z_scFunk = New Collection 'If this is the first time through, do the one-time initialization
      On Error GoTo CatchDoubleSub                              'Catch double subclassing
      Call z_scFunk.Add(z_ScMem, "h" & lng_hWnd)                'Add the hWnd/thunk-address to the collection
      On Error GoTo 0
      
   'z_Sc (0) thru z_Sc(17) are used as storage for the thunks & IDX_ constants above relate to these thunk positions which are filled in below
    z_Sc(18) = &HD231C031: z_Sc(19) = &HBBE58960: z_Sc(21) = &H21E8F631: z_Sc(22) = &HE9000001: z_Sc(23) = &H12C&: z_Sc(24) = &HD231C031: z_Sc(25) = &HBBE58960: z_Sc(27) = &H3FFF631: z_Sc(28) = &H75047339: z_Sc(29) = &H2873FF23: z_Sc(30) = &H751C53FF: z_Sc(31) = &HC433913: z_Sc(32) = &H53FF2274: z_Sc(33) = &H13D0C: z_Sc(34) = &H18740000: z_Sc(35) = &H875C085: z_Sc(36) = &H820443C7: z_Sc(37) = &H90000000: z_Sc(38) = &H87E8&: z_Sc(39) = &H22E900: z_Sc(40) = &H90900000: z_Sc(41) = &H2C7B8B4A: z_Sc(42) = &HE81C7589: z_Sc(43) = &H90&: z_Sc(44) = &H75147539: z_Sc(45) = &H6AE80F: z_Sc(46) = &HD2310000: z_Sc(47) = &HE8307B8B: z_Sc(48) = &H7C&: z_Sc(49) = &H7D810BFF: z_Sc(50) = &H8228&: z_Sc(51) = &HC7097500: z_Sc(52) = &H80000443: z_Sc(53) = &H90900000: z_Sc(54) = &H44753339: z_Sc(55) = &H74047339: z_Sc(56) = &H2473FF3F: z_Sc(57) = &HFFFFFC68
    z_Sc(58) = &H2475FFFF: z_Sc(59) = &H811453FF: z_Sc(60) = &H82047B: z_Sc(61) = &HC750000: z_Sc(62) = &H74387339: z_Sc(63) = &H2475FF07: z_Sc(64) = &H903853FF: z_Sc(65) = &H81445B89: z_Sc(66) = &H484443: z_Sc(67) = &H73FF0000: z_Sc(68) = &H646844: z_Sc(69) = &H56560000: z_Sc(70) = &H893C53FF: z_Sc(71) = &H90904443: z_Sc(72) = &H10C261: z_Sc(73) = &H53E8&: z_Sc(74) = &H3075FF00: z_Sc(75) = &HFF2C75FF: z_Sc(76) = &H75FF2875: z_Sc(77) = &H2473FF24: z_Sc(78) = &H891053FF: z_Sc(79) = &H90C31C45: z_Sc(80) = &H34E30F8B: z_Sc(81) = &H1078C985: z_Sc(82) = &H4C781: z_Sc(83) = &H458B0000: z_Sc(84) = &H75AFF228: z_Sc(85) = &H90909023: z_Sc(86) = &H8D144D8D: z_Sc(87) = &H8D503443: z_Sc(88) = &H75FF1C45: z_Sc(89) = &H2C75FF30: z_Sc(90) = &HFF2875FF: z_Sc(91) = &H51502475: z_Sc(92) = &H2073FF52: z_Sc(93) = &H902853FF: z_Sc(94) = &H909090C3: z_Sc(95) = &H74447339: z_Sc(96) = &H4473FFF7
    z_Sc(97) = &H4053FF56: z_Sc(98) = &HC3447389: z_Sc(99) = &H89285D89: z_Sc(100) = &H45C72C75: z_Sc(101) = &H800030: z_Sc(102) = &H20458B00: z_Sc(103) = &H89145D89: z_Sc(104) = &H81612445: z_Sc(105) = &H4C4&: z_Sc(106) = &H1862FF00

    ' cache callback related pointers & offsets
      z_Sc(IDX_EBX) = z_ScMem                                                 'Patch the thunk data address
      z_Sc(IDX_EBX_TMR) = z_ScMem                                             'Patch the thunk data address
      z_Sc(IDX_INDEX) = lng_hWnd                                              'Store the window handle in the thunk data
      z_Sc(IDX_BTABLE) = z_ScMem + CODE_LEN                                   'Store the address of the before table in the thunk data
      z_Sc(IDX_ATABLE) = z_ScMem + CODE_LEN + ((MSG_ENTRIES + 1) * 4)         'Store the address of the after table in the thunk data
      z_Sc(IDX_OWNER) = ObjPtr(oCallback)                                     'Store the callback owner's object address in the thunk data
      z_Sc(IDX_CALLBACK) = nAddr                                              'Store the callback address in the thunk data
      z_Sc(IDX_PARM_USER) = lParamUser                                        'Store the lParamUser callback parameter in the thunk data
      
      ' validate unicode request & cache unicode usage
      If bUnicode Then bUnicode = (IsWindowUnicode(lng_hWnd) <> 0&)
      z_Sc(IDX_UNICODE) = bUnicode                                            'Store whether the window is using unicode calls or not
      
      ' get function pointers for the thunk
      If bIdeSafety = True Then                                               'If the user wants IDE protection
          Debug.Assert zInIDE(bIDE)
          If bIDE = True Then z_Sc(IDX_EBMODE) = zFnAddr("vba6", "EbMode", bUnicode) 'Store the EbMode function address in the thunk data
                                                        '^^ vb5 users, change vba6 to vba5
      End If
      If bIsAPIwindow Then                                                    'If user wants DestroyWindow sent should IDE end
          z_Sc(IDX_DW) = zFnAddr("user32", "DestroyWindow", bUnicode)
      End If
      z_Sc(IDX_FREE) = zFnAddr("kernel32", "VirtualFree", bUnicode)           'Store the VirtualFree function address in the thunk data
      z_Sc(IDX_BADPTR) = zFnAddr("kernel32", "IsBadCodePtr", bUnicode)        'Store the IsBadCodePtr function address in the thunk data
      z_Sc(IDX_ST) = zFnAddr("user32", "SetTimer", bUnicode)                  'Store the SetTimer function address in the thunk data
      z_Sc(IDX_KT) = zFnAddr("user32", "KillTimer", bUnicode)                 'Store the KillTimer function address in the thunk data
      
      If bUnicode Then
          z_Sc(IDX_CWP) = zFnAddr("user32", "CallWindowProcW", bUnicode)      'Store CallWindowProc function address in the thunk data
          z_Sc(IDX_SWL) = zFnAddr("user32", "SetWindowLongW", bUnicode)       'Store the SetWindowLong function address in the thunk data
          RtlMoveMemory z_ScMem, VarPtr(z_Sc(0)), CODE_LEN                    'Copy the thunk code/data to the allocated memory
          z_Sc(IDX_PREVPROC) = SetWindowLongW(lng_hWnd, GWL_WNDPROC, z_ScMem + WNDPROC_OFF) 'Set the new WndProc, return the address of the original WndProc
      Else
          z_Sc(IDX_CWP) = zFnAddr("user32", "CallWindowProcA", bUnicode)      'Store CallWindowProc function address in the thunk data
          z_Sc(IDX_SWL) = zFnAddr("user32", "SetWindowLongA", bUnicode)       'Store the SetWindowLong function address in the thunk data
          RtlMoveMemory z_ScMem, VarPtr(z_Sc(0)), CODE_LEN                    'Copy the thunk code/data to the allocated memory
          z_Sc(IDX_PREVPROC) = SetWindowLongA(lng_hWnd, GWL_WNDPROC, z_ScMem + WNDPROC_OFF) 'Set the new WndProc, return the address of the original WndProc
      End If
      If z_Sc(IDX_PREVPROC) = 0 Then                                          'Ensure the new WndProc was set correctly
          zError SUB_NAME, "SetWindowLong failed, error #" & Err.LastDllError
          GoTo ReleaseMemory
      End If
      'Store the original WndProc address in the thunk data
      Call RtlMoveMemory(z_ScMem + IDX_PREVPROC * 4, VarPtr(z_Sc(IDX_PREVPROC)), 4&)
      ssc_Subclass = True                                                     'Indicate success
    Else
        Call zError(SUB_NAME, "VirtualAlloc failed, error: " & Err.LastDllError)
    End If
 Exit Function                                                                'Exit ssc_Subclass
    
CatchDoubleSub:
 Call zError(SUB_NAME, "Window handle is already subclassed")
      
ReleaseMemory:
      Call VirtualFree(z_ScMem, 0, MEM_RELEASE)                               'ssc_Subclass has failed after memory allocation, so release the memory
End Function

'Terminate all subclassing
Private Sub ssc_Terminate()
    ' can be made public, can be removed & zTerminateThunks can be called instead
    Call zTerminateThunks(SubclassThunk)
End Sub

'UnSubclass the specified window handle
Private Sub ssc_UnSubclass(ByVal lng_hWnd As Long)
    ' can be made public, can be removed & zUnthunk can be called instead
    Call zUnThunk(lng_hWnd, SubclassThunk)
End Sub

'Add the message value to the window handle's specified callback table
Private Sub ssc_AddMsg(ByVal lng_hWnd As Long, ByVal When As eMsgWhen, ParamArray Messages() As Variant)
    Dim z_ScMem       As Long                                   'Thunk base address
    
    z_ScMem = zMap_VFunction(lng_hWnd, SubclassThunk)           'Ensure that the thunk hasn't already released its memory
    If z_ScMem Then
      Dim M As Long
      For M = LBound(Messages) To UBound(Messages)
        Select Case VarType(Messages(M))                        ' ensure no strings, arrays, doubles, objects, etc are passed
        Case vbByte, vbInteger, vbLong
            If When And MSG_BEFORE Then                         'If the message is to be added to the before original WndProc table...
              If zAddMsg(Messages(M), IDX_BTABLE, z_ScMem) = False Then 'Add the message to the before table
                When = (When And Not MSG_BEFORE)
              End If
            End If
            If When And MSG_AFTER Then                          'If message is to be added to the after original WndProc table...
              If zAddMsg(Messages(M), IDX_ATABLE, z_ScMem) = False Then 'Add the message to the after table
                When = (When And Not MSG_AFTER)
              End If
            End If
        End Select
      Next
    End If
End Sub

'Delete the message value from the window handle's specified callback table
Private Sub ssc_DelMsg(ByVal lng_hWnd As Long, ByVal When As eMsgWhen, ParamArray Messages() As Variant)
    Dim z_ScMem       As Long                           'Thunk base address
    z_ScMem = zMap_VFunction(lng_hWnd, SubclassThunk)   'Ensure that the thunk hasn't already released its memory
    If z_ScMem Then
      Dim M As Long
      For M = LBound(Messages) To UBound(Messages) ' ensure no strings, arrays, doubles, objects, etc are passed
        Select Case VarType(Messages(M))
        Case vbByte, vbInteger, vbLong
            If When And MSG_BEFORE Then            'If the message is to be removed from the before original WndProc table...
              Call zDelMsg(Messages(M), IDX_BTABLE, z_ScMem) 'Remove the message to the before table
            End If
            If When And MSG_AFTER Then                       'If message is to be removed from the after original WndProc table...
              zDelMsg Messages(M), IDX_ATABLE, z_ScMem       'Remove the message to the after table
            End If
        End Select
      Next
    End If
End Sub

'Call the original WndProc
Private Function ssc_CallOrigWndProc(ByVal lng_hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    ' can be made public, can be removed if you will not use this in your window procedure
    Dim z_ScMem       As Long                           'Thunk base address
    z_ScMem = zMap_VFunction(lng_hWnd, SubclassThunk)
    If z_ScMem Then                                     'Ensure that the thunk hasn't already released its memory
        If zData(IDX_UNICODE, z_ScMem) Then
            ssc_CallOrigWndProc = CallWindowProcW(zData(IDX_PREVPROC, z_ScMem), lng_hWnd, uMsg, wParam, lParam) 'Call the original WndProc of the passed window handle parameter
        Else
            ssc_CallOrigWndProc = CallWindowProcA(zData(IDX_PREVPROC, z_ScMem), lng_hWnd, uMsg, wParam, lParam) 'Call the original WndProc of the passed window handle parameter
        End If
    End If
End Function

'Get the subclasser lParamUser callback parameter
Private Function zGet_lParamUser(ByVal hWnd_Hook_ID As Long, ByVal vType As eThunkType) As Long
    ' can be removed if you never will retrieve or replace the user-defined parameter
    If vType <> CallbackThunk Then
        Dim z_ScMem       As Long                                       'Thunk base address
        z_ScMem = zMap_VFunction(hWnd_Hook_ID, vType)
        If z_ScMem Then                                                 'Ensure that the thunk hasn't already released its memory
          zGet_lParamUser = zData(IDX_PARM_USER, z_ScMem)               'Get the lParamUser callback parameter
        End If
    End If
End Function

'Let the subclasser lParamUser callback parameter
Private Sub zSet_lParamUser(ByVal hWnd_Hook_ID As Long, ByVal vType As eThunkType, ByVal NewValue As Long)
    ' can be removed if you never will retrieve or replace the user-defined parameter
    If vType <> CallbackThunk Then
        Dim z_ScMem       As Long                                       'Thunk base address
        z_ScMem = zMap_VFunction(hWnd_Hook_ID, vType)
        If z_ScMem Then                                                 'Ensure that the thunk hasn't already released its memory
          zData(IDX_PARM_USER, z_ScMem) = NewValue                      'Set the lParamUser callback parameter
        End If
    End If
End Sub

'Add the message to the specified table of the window handle
Private Function zAddMsg(ByVal uMsg As Long, ByVal nTable As Long, ByVal z_ScMem As Long) As Boolean
      Dim nCount As Long                            'Table entry count
      Dim nBase  As Long
      Dim i      As Long                            'Loop index
    
      zAddMsg = True
      nBase = zData(nTable, z_ScMem)                'Map zData() to the specified table
      
      If uMsg = ALL_MESSAGES Then                   'If ALL_MESSAGES are being added to the table...
        nCount = ALL_MESSAGES                       'Set the table entry count to ALL_MESSAGES
      Else
        
        nCount = zData(0, nBase)                    'Get the current table entry count
        For i = 1 To nCount                         'Loop through the table entries
          If zData(i, nBase) = 0 Then               'If the element is free...
            zData(i, nBase) = uMsg                  'Use this element
            GoTo Bail                               'Bail
          ElseIf zData(i, nBase) = uMsg Then        'If the message is already in the table...
            GoTo Bail                               'Bail
          End If
        Next i                                      'Next message table entry
    
        nCount = i                                  'On drop through: i = nCount + 1, the new table entry count
        If nCount > MSG_ENTRIES Then                'Check for message table overflow
          Call zError("zAddMsg", "Message table overflow. Either increase the value of Const MSG_ENTRIES or use ALL_MESSAGES instead of specific message values")
          zAddMsg = False
          GoTo Bail
        End If
        
        zData(nCount, nBase) = uMsg                                            'Store the message in the appended table entry
      End If
    
      zData(0, nBase) = nCount                                                 'Store the new table entry count
Bail:
End Function

'Delete the message from the specified table of the window handle
Private Sub zDelMsg(ByVal uMsg As Long, ByVal nTable As Long, ByVal z_ScMem As Long)
      Dim nCount As Long                                                        'Table entry count
      Dim nBase  As Long
      Dim i      As Long                                                        'Loop index
    
      nBase = zData(nTable, z_ScMem)                                            'Map zData() to the specified table
    
      If uMsg = ALL_MESSAGES Then                                               'If ALL_MESSAGES are being deleted from the table...
        zData(0, nBase) = 0                                                     'Zero the table entry count
      Else
        nCount = zData(0, nBase)                                                'Get the table entry count
        
        For i = 1 To nCount                                                     'Loop through the table entries
          If zData(i, nBase) = uMsg Then                                        'If the message is found...
            zData(i, nBase) = 0                                                 'Null the msg value -- also frees the element for re-use
            GoTo Bail                                                           'Bail
          End If
        Next i                                                                  'Next message table entry
       ' zError "zDelMsg", "Message &H" & Hex$(uMsg) & " not found in table"
      End If
Bail:
End Sub

'-SelfCallback code------------------------------------------------------------------------------------
'-The following routines are exclusively for the scb_SetCallbackAddr routines----------------------------
Private Function scb_SetCallbackAddr(ByVal nParamCount As Long, _
                     Optional ByVal nOrdinal As Long = 1, _
                     Optional ByVal oCallback As Object = Nothing, _
                     Optional ByVal bIdeSafety As Boolean = True, _
                     Optional ByVal bIsTimerCallback As Boolean) As Long   'Return the address of the specified callback thunk
    '*************************************************************************************************
    '* nParamCount  - The number of parameters that will callback
    '* nOrdinal     - Callback ordinal number, the final private method is ordinal 1, the second last is ordinal 2, etc...
    '* oCallback    - Optional, the object that will receive the callback. If undefined, callbacks are sent to this object's instance
    '* bIdeSafety   - Optional, set to false to disable IDE protection.
    '* bIsTimerCallback - optional, set to true for extra protection when used as a SetTimer callback
    '       If True, timer will be destroyed when IDE/app terminates. See scb_ReleaseCallback.
    '*************************************************************************************************
    ' Callback procedure must return a Long even if, per MSDN, the callback procedure is a Sub vs Function
    ' The number of parameters and their types are dependent on the individual callback procedures
    
    Const MEM_LEN     As Long = IDX_CALLBACKORDINAL * 4 + 4     'Memory bytes required for the callback thunk
    Const PAGE_RWX    As Long = &H40&                           'Allocate executable memory
    Const MEM_COMMIT  As Long = &H1000&                         'Commit allocated memory
    Const SUB_NAME      As String = "scb_SetCallbackAddr"       'This routine's name
    Const INDX_OWNER    As Long = 0                             'Thunk data index of the Owner object's vTable address
    Const INDX_CALLBACK As Long = 1                             'Thunk data index of the EbMode function address
    Const INDX_EBMODE   As Long = 2                             'Thunk data index of the IsBadCodePtr function address
    Const INDX_BADPTR   As Long = 3                             'Thunk data index of the IsBadCodePtr function address
    Const INDX_KT       As Long = 4                             'Thunk data index of the KillTimer function address
    Const INDX_EBX      As Long = 6                             'Thunk code patch index of the thunk data
    Const INDX_PARAMS   As Long = 18                            'Thunk code patch index of the number of parameters expected in callback
    Const INDX_PARAMLEN As Long = 24                            'Thunk code patch index of the bytes to be released after callback
    Const PROC_OFF      As Long = &H14                          'Thunk offset to the callback execution address

    Dim z_ScMem       As Long                                   'Thunk base address
    Dim z_Cb()    As Long                                       'Callback thunk array
    Dim nValue    As Long
    Dim nCallback As Long
    Dim bIDE      As Boolean
      
    If oCallback Is Nothing Then Set oCallback = Me     'If the user hasn't specified the callback owner
    If z_cbFunk Is Nothing Then
        Set z_cbFunk = New Collection           'If this is the first time through, do the one-time initialization
    Else
        On Error Resume Next                    'Catch already initialized?
        z_ScMem = z_cbFunk.item("h" & ObjPtr(oCallback) & "." & nOrdinal) 'Test it
        If Err = 0 Then
            scb_SetCallbackAddr = z_ScMem + PROC_OFF  'we had this one, just reference it
            Exit Function
        End If
        On Error GoTo 0
    End If
    
    If nParamCount < 0 Then                     ' validate parameters
        Call zError(SUB_NAME, "Invalid Parameter count")
        Exit Function
    End If
    If oCallback Is Nothing Then
        Set oCallback = Me
    End If
    nCallback = zAddressOf(oCallback, nOrdinal)         'Get the callback address of the specified ordinal
    If nCallback = 0 Then
        Call zError(SUB_NAME, "Callback address not found.")
        Exit Function
    End If
    z_ScMem = VirtualAlloc(0, MEM_LEN, MEM_COMMIT, PAGE_RWX) 'Allocate executable memory
        
    If z_ScMem = 0& Then
        Call zError(SUB_NAME, "VirtualAlloc failed, error: " & Err.LastDllError)  ' oops
        Exit Function
    End If
    Call z_cbFunk.Add(z_ScMem, "h" & ObjPtr(oCallback) & "." & nOrdinal) 'Add the callback/thunk-address to the collection
        
    ReDim z_Cb(0 To IDX_CALLBACKORDINAL) As Long          'Allocate for the machine-code array
    
    ' Create machine-code array
    z_Cb(5) = &HBB60E089: z_Cb(7) = &H73FFC589: z_Cb(8) = &HC53FF04: z_Cb(9) = &H59E80A74: z_Cb(10) = &HE9000000
    z_Cb(11) = &H30&: z_Cb(12) = &H87B81: z_Cb(13) = &H75000000: z_Cb(14) = &H9090902B: z_Cb(15) = &H42DE889: z_Cb(16) = &H50000000: z_Cb(17) = &HB9909090: z_Cb(19) = &H90900AE3
    z_Cb(20) = &H8D74FF: z_Cb(21) = &H9090FAE2: z_Cb(22) = &H53FF33FF: z_Cb(23) = &H90909004: z_Cb(24) = &H2BADC261: z_Cb(25) = &H3D0853FF: z_Cb(26) = &H1&: z_Cb(27) = &H23DCE74: z_Cb(28) = &H74000000: z_Cb(29) = &HAE807
    z_Cb(30) = &H90900000: z_Cb(31) = &H4589C031: z_Cb(32) = &H90DDEBFC: z_Cb(33) = &HFF0C75FF: z_Cb(34) = &H53FF0475: z_Cb(35) = &HC310&

    z_Cb(INDX_BADPTR) = zFnAddr("kernel32", "IsBadCodePtr", False)
    z_Cb(INDX_OWNER) = ObjPtr(oCallback)                    'Set the Owner
    z_Cb(INDX_CALLBACK) = nCallback                         'Set the callback address
    z_Cb(IDX_CALLBACKORDINAL) = nOrdinal                    'Cache ordinal used for zTerminateThunks
      
    If bIdeSafety = True Then                               'If the user wants IDE protection
        Debug.Assert zInIDE(bIDE)
        If bIDE = True Then z_Cb(INDX_EBMODE) = zFnAddr("vba6", "EbMode", False) 'Store the EbMode function address in the thunk data
    End If
    If bIsTimerCallback Then
        z_Cb(INDX_KT) = zFnAddr("user32", "KillTimer", False)
    End If
        
    z_Cb(INDX_PARAMS) = nParamCount                         'Set the parameter count
    Call RtlMoveMemory(VarPtr(z_Cb(INDX_PARAMLEN)) + 2, VarPtr(nParamCount * 4), 2&)

    z_Cb(INDX_EBX) = z_ScMem                                'Set the data address relative to virtual memory pointer

    Call RtlMoveMemory(z_ScMem, VarPtr(z_Cb(INDX_OWNER)), MEM_LEN) 'Copy thunk code to executable memory
    scb_SetCallbackAddr = z_ScMem + PROC_OFF                       'Thunk code start address
End Function

Private Sub scb_ReleaseCallback(ByVal nOrdinal As Long, Optional ByVal oCallback As Object)
    ' can be made public, can be removed & zUnThunk can be called instead
    ' NEVER call this from within the callback routine itself
    
    ' oCallBack is the object containing nOrdinal to be released
    ' if oCallback was already closed (say it was a class or form), then you won't be
    '   able to release it here, but it will be released when zTerminateThunks is
    '   eventually called
    
    ' Special Warning. If the callback thunk is used for a recurring callback (i.e., Timer),
    ' then ensure you terminate what is using the callback before releasing the thunk,
    ' otherwise you are subject to a crash when that item tries to callback to zeroed memory
    Call zUnThunk(nOrdinal, CallbackThunk, oCallback)
End Sub

Private Sub scb_TerminateCallbacks()
    ' can be made public, can be removed & zTerminateThunks can be called instead
    Call zTerminateThunks(CallbackThunk)
End Sub


'-The following routines are used for each of the three types of thunks ----------------------------

'Maps zData() to the memory address for the specified thunk type
Private Function zMap_VFunction(vFuncTarget As Long, _
                                vType As eThunkType, _
                                Optional oCallback As Object, _
                                Optional bIgnoreErrors As Boolean) As Long
    
    Dim thunkCol As Collection
    Dim colID As String
    Dim z_ScMem       As Long         'Thunk base address
    
    If vType = CallbackThunk Then
        Set thunkCol = z_cbFunk
        If oCallback Is Nothing Then Set oCallback = Me
        colID = "h" & ObjPtr(oCallback) & "." & vFuncTarget
    ElseIf vType = SubclassThunk Then
        Set thunkCol = z_scFunk
        colID = "h" & vFuncTarget
    Else
        Call zError("zMap_Vfunction", "Invalid thunk type passed")
        Exit Function
    End If
    
    If thunkCol Is Nothing Then
        Call zError("zMap_VFunction", "Thunk hasn't been initialized")
    Else
        If thunkCol.Count Then
            On Error GoTo Catch
            z_ScMem = thunkCol(colID)               'Get the thunk address
            If IsBadCodePtr(z_ScMem) Then z_ScMem = 0&
            zMap_VFunction = z_ScMem
        End If
    End If
    Exit Function                                   'Exit returning the thunk address
Catch:
    ' error ignored when zUnThunk is called, error handled there
    If Not bIgnoreErrors Then Call zError("zMap_VFunction", "Thunk type for " & vType & " does not exist")
End Function

' sets/retrieves data at the specified offset for the specified memory address
Private Property Get zData(ByVal nIndex As Long, ByVal z_ScMem As Long) As Long
  Call RtlMoveMemory(VarPtr(zData), z_ScMem + (nIndex * 4), 4)
End Property

Private Property Let zData(ByVal nIndex As Long, ByVal z_ScMem As Long, ByVal nValue As Long)
  Call RtlMoveMemory(z_ScMem + (nIndex * 4), VarPtr(nValue), 4)
End Property

'Error handler
Private Sub zError(ByRef sRoutine As String, ByVal sMsg As String)
  ' Note. These two lines can be rem'd out if you so desire. But don't remove the routine
  ' App.LogEvent TypeName(Me) & "." & sRoutine & ": " & sMsg, vbLogEventTypeError
  Call MsgBox(sMsg & ".", vbExclamation + vbApplicationModal, "Error in " & TypeName(Me) & "." & sRoutine)
End Sub

'Return the address of the specified DLL/procedure
Private Function zFnAddr(ByVal sDLL As String, ByVal sProc As String, ByVal asUnicode As Boolean) As Long
  If asUnicode Then
    zFnAddr = GetProcAddress(GetModuleHandleW(StrPtr(sDLL)), sProc)         'Get the specified procedure address
  Else
    zFnAddr = GetProcAddress(GetModuleHandleA(sDLL), sProc)                 'Get the specified procedure address
  End If
  Debug.Assert zFnAddr                                                      'In the IDE, validate that the procedure address was located
  ' ^^ FYI VB5 users. Search for zFnAddr("vba6", "EbMode") and replace with zFnAddr("vba5", "EbMode")
End Function

'Return the address of the specified ordinal method on the oCallback object, 1 = last private method, 2 = second last private method, etc
Private Function zAddressOf(ByVal oCallback As Object, ByVal nOrdinal As Long) As Long
    ' Note: used both in subclassing and hooking routines
  Dim bSub  As Byte                                     'Value we expect to find pointed at by a vTable method entry
  Dim bVal  As Byte
  Dim nAddr As Long                                     'Address of the vTable
  Dim i     As Long                                     'Loop index
  Dim J     As Long                                     'Loop limit
  
  Call RtlMoveMemory(VarPtr(nAddr), ObjPtr(oCallback), 4) 'Get the address of the callback object's instance
  If Not zProbe(nAddr + &H1C, i, bSub) Then             'Probe for a Class method
    If Not zProbe(nAddr + &H6F8, i, bSub) Then          'Probe for a Form method
      If Not zProbe(nAddr + &H710, i, bSub) Then        'Probe for a PropertyPage method
        If Not zProbe(nAddr + &H7A4, i, bSub) Then      'Probe for a UserControl method
            Exit Function                               'Bail...
        End If
      End If
    End If
  End If
  
  i = i + 4                                             'Bump to the next entry
  J = i + 2048                                          'Set a reasonable limit, scan 512 vTable entries
  Do While i < J
    Call RtlMoveMemory(VarPtr(nAddr), i, 4)             'Get the address stored in this vTable entry
    
    If IsBadCodePtr(nAddr) Then                                     'Is the entry an invalid code address?
      Call RtlMoveMemory(VarPtr(zAddressOf), i - (nOrdinal * 4), 4) 'Return the specified vTable entry address
      Exit Do                                                       'Bad method signature, quit loop
    End If

    Call RtlMoveMemory(VarPtr(bVal), nAddr, 1)                      'Get the byte pointed to by the vTable entry
    If bVal <> bSub Then                                            'If the byte doesn't match the expected value...
      Call RtlMoveMemory(VarPtr(zAddressOf), i - (nOrdinal * 4), 4) 'Return the specified vTable entry address
      Exit Do                                                       'Bad method signature, quit loop
    End If
    
    i = i + 4                                                       'Next vTable entry
  Loop
End Function

'Probe at the specified start address for a method signature
Private Function zProbe(ByVal nStart As Long, ByRef nMethod As Long, ByRef bSub As Byte) As Boolean
  Dim bVal    As Byte
  Dim nAddr   As Long
  Dim nLimit  As Long
  Dim nEntry  As Long
  
  nAddr = nStart                                                    'Start address
  nLimit = nAddr + 32                                               'Probe eight entries
  Do While nAddr < nLimit                                           'While we've not reached our probe depth
    Call RtlMoveMemory(VarPtr(nEntry), nAddr, 4)                    'Get the vTable entry
    
    If nEntry <> 0 Then                                             'If not an implemented interface
      Call RtlMoveMemory(VarPtr(bVal), nEntry, 1)                   'Get the value pointed at by the vTable entry
      If bVal = &H33 Or bVal = &HE9 Then                            'Check for a native or pcode method signature
        nMethod = nAddr                                             'Store the vTable entry
        bSub = bVal                                                 'Store the found method signature
        zProbe = True                                               'Indicate success
        Exit Do                                                     'Return
      End If
    End If
    nAddr = nAddr + 4                                               'Next vTable entry
  Loop
End Function

Private Function zInIDE(ByRef bIDE As Boolean) As Boolean
    ' only called in IDE, never called when compiled
    bIDE = True
    zInIDE = bIDE
End Function

Private Sub zUnThunk(ByVal thunkID As Long, ByVal vType As eThunkType, Optional ByVal oCallback As Object)
    ' thunkID, depends on vType:
    '   - Subclassing:  the hWnd of the window subclassed
    '   - Callbacks:    the ordinal of the callback
    '       ensure KillTimer is already called, if any callback used for SetTimer
    ' oCallback only used when vType is CallbackThunk
    Const IDX_SHUTDOWN  As Long = 1
    Const MEM_RELEASE As Long = &H8000&             'Release allocated memory flag
    
    Dim z_ScMem       As Long                       'Thunk base address
    
    z_ScMem = zMap_VFunction(thunkID, vType, oCallback, True)
    Select Case vType
    Case SubclassThunk
        If z_ScMem Then                         'Ensure that the thunk hasn't already released its memory
            zData(IDX_SHUTDOWN, z_ScMem) = 1                  'Set the shutdown indicator
            Call zDelMsg(ALL_MESSAGES, IDX_BTABLE, z_ScMem)   'Delete all before messages
            Call zDelMsg(ALL_MESSAGES, IDX_ATABLE, z_ScMem)   'Delete all after messages
        End If
        Call z_scFunk.Remove("h" & thunkID)                   'Remove the specified thunk from the collection
    Case CallbackThunk
        If z_ScMem Then                         'Ensure that the thunk hasn't already released its memory
            Call VirtualFree(z_ScMem, 0, MEM_RELEASE)   'Release allocated memory
        End If
        Call z_cbFunk.Remove("h" & ObjPtr(oCallback) & "." & thunkID) 'Remove the specified thunk from the collection
    End Select
End Sub

Private Sub zTerminateThunks(ByVal vType As eThunkType)
    ' Terminates all thunks of a specific type
    ' Any subclassing, recurring callbacks should have already been canceled
    Dim i As Long
    Dim oCallback As Object
    Dim thunkCol As Collection
    Dim z_ScMem       As Long                           'Thunk base address
    Const INDX_OWNER As Long = 0
    
    Select Case vType
    Case SubclassThunk
        Set thunkCol = z_scFunk
    Case CallbackThunk
        Set thunkCol = z_cbFunk
    Case Else
        Exit Sub
    End Select
    
    If Not (thunkCol Is Nothing) Then                 'Ensure that hooking has been started
      With thunkCol
        For i = .Count To 1 Step -1                   'Loop through the collection of hook types in reverse order
          z_ScMem = .item(i)                          'Get the thunk address
          If IsBadCodePtr(z_ScMem) = 0 Then           'Ensure that the thunk hasn't already released its memory
            Select Case vType
                Case SubclassThunk
                    zUnThunk zData(IDX_INDEX, z_ScMem), SubclassThunk    'Unsubclass
                Case CallbackThunk
                    ' zUnThunk expects object not pointer, convert pointer to object
                    Call RtlMoveMemory(VarPtr(oCallback), VarPtr(zData(INDX_OWNER, z_ScMem)), 4&)
                    Call zUnThunk(zData(IDX_CALLBACKORDINAL, z_ScMem), CallbackThunk, oCallback) ' release callback
                    ' remove the object pointer reference
                    Call RtlMoveMemory(VarPtr(oCallback), VarPtr(INDX_OWNER), 4&)
            End Select
          End If
        Next i                                        'Next member of the collection
      End With
      Set thunkCol = Nothing                         'Destroy the hook/thunk-address collection
    End If
End Sub

'----------------------------------------------------------------------------------------
' MouseEnter/Leave support
'----------------------------------------------------------------------------------------

'Track the mouse leaving the indicated window
Private Sub pvTrackMouseLeave(ByVal lng_hWnd As Long)
  Dim uTME As TRACKMOUSEEVENT_STRUCT
    With uTME
        .cbSize = Len(uTME)
        .dwFlags = TME_LEAVE
        .hwndTrack = lng_hWnd
    End With
    Call TrackMouseEvent(uTME)
End Sub

' === Call InterfaceMethod ===============================================
' This function was made by ANDRay, wich can be found in http://www.planetsourcecode.com/vb/scripts/ShowCode.asp?lngWId=1&txtCodeId=72856
Private Function CallInterface(ByVal pInterface As Long, ByVal Member As Long, ByVal ParamsCount As Long, Optional ByVal p1 As Long = 0, Optional ByVal p2 As Long = 0, Optional ByVal p3 As Long = 0, Optional ByVal p4 As Long = 0, Optional ByVal p5 As Long = 0, Optional ByVal p6 As Long = 0, Optional ByVal p7 As Long = 0, Optional ByVal p8 As Long = 0, Optional ByVal p9 As Long = 0, Optional ByVal p10 As Long = 0) As Long
  Dim i As Long, t As Long
  Dim hGlobal As Long, hGlobalOffset As Long
  
  If ParamsCount < 0 Then Err.Raise 5 'invalid call
  If pInterface = 0 Then Err.Raise 5
  
  ' 5 Bytes por parametro (4 bytes + PUSH)
  ' 5 Bytes = 1 push + Puntero a interfaz
  hGlobal = GlobalAlloc(GMEM_FIXED, 5 * ParamsCount + 5 + 5 + 3 + 1)
  If hGlobal = 0 Then Err.Raise 7 'insuff. memory
  hGlobalOffset = hGlobal
  
  If ParamsCount > 0 Then
    t = VarPtr(p1)
    For i = ParamsCount - 1 To 0 Step -1
      Call PutMem2(hGlobalOffset, asmPUSH_imm32)
      hGlobalOffset = hGlobalOffset + 1
      Call GetMem4(t + i * 4, hGlobalOffset)
      hGlobalOffset = hGlobalOffset + 4
    Next
  End If
  
  ' PUSH y ponemos el puntero a la interfas
  Call PutMem2(hGlobalOffset, asmPUSH_imm32)
  hGlobalOffset = hGlobalOffset + 1
  Call PutMem4(hGlobalOffset, pInterface)
  hGlobalOffset = hGlobalOffset + 4
  
  ' Llamamos
  Call PutMem2(hGlobalOffset, asmCALL_rel32)
  hGlobalOffset = hGlobalOffset + 1
  Call GetMem4(pInterface, VarPtr(t))     ':   vTable
  Call GetMem4(t + Member * 4, VarPtr(t)) '  vTable,    
  Call PutMem4(hGlobalOffset, t - hGlobalOffset - 4)
  hGlobalOffset = hGlobalOffset + 4
  
  Call PutMem4(hGlobalOffset, &H10C2&)        'ret 0x0010
  CallInterface = CallWindowProcA(hGlobal, 0, 0, 0, 0)
  Call GlobalFree(hGlobal)
End Function

'----------------------------------------------------------------------------------------
' IOLEInPlaceActiveObject interface
'----------------------------------------------------------------------------------------
Private Sub pvInitIPAO()
    Dim uiid As uuid
    ptrMe = ObjPtr(Me)
    With m_uIPAO
        .lpVTable = GetVTable
        Call IIDFromString(StrPtr(IID_IOleInPlaceActive), uiid)
        Call CallInterface(ptrMe, IUnknown_Exports.QueryInterface, 2, VarPtr(uiid), VarPtr(.IPAOReal))
        .ThisPointer = VarPtr(m_uIPAO)
    End With
End Sub

Private Sub pvSetIPAO()
    Const IOleObject_GetClientSite As Long = 4 ' 2 From IUnknown + 2 Ordinal
    Const IOleObject_DoVerb As Long = 11
    Const IOleInPlaceSite_GetWindowContext As Long = 8 ' 2 from IUnknown + 2 IOleWindow + 4 Ordinal
    Const IOleInPlaceFrame_SetActiveObject As Long = 8 ' 2 from IUnknown + 2 IOleWindow + 4 Ordinal
    Const IOleInPlaceUIWindow_SetActiveObject As Long = 8 ' IOleInPlaceFrame inherits from IOleInPlaceUIWindow
    
    Const OLEIVERB_UIACTIVATE As Long = -4
    Dim uiid As uuid, lResult As Long
    Dim pOleObject          As Long 'IOleObject
    Dim pOleInPlaceSite     As Long 'IOleInPlaceSite
    Dim pOleInPlaceFrame    As Long 'IOleInPlaceFrame
    Dim pOleInPlaceUIWindow As Long 'IOleInPlaceUIWindow
    Dim rcPos               As RECT
    Dim rcClip              As RECT
    Dim uFrameInfo          As OLEINPLACEFRAMEINFO
    
    On Error Resume Next
    Call IIDFromString(StrPtr(IID_IOleObject), uiid)
    Call CallInterface(ptrMe, IUnknown_Exports.QueryInterface, 2, VarPtr(uiid), VarPtr(pOleObject))
    Call CallInterface(pOleObject, IOleObject_GetClientSite, 1, VarPtr(pOleInPlaceSite))
    
    If pOleInPlaceSite <> 0 Then
        Call IIDFromString(StrPtr(IID_IOleInPlaceSite), uiid)
        Call CallInterface(pOleInPlaceSite, IUnknown_Exports.QueryInterface, 2, VarPtr(uiid), VarPtr(pOleInPlaceSite))
        Call CallInterface(pOleInPlaceSite, IOleInPlaceSite_GetWindowContext, 5, VarPtr(pOleInPlaceFrame), VarPtr(pOleInPlaceUIWindow), VarPtr(rcPos), VarPtr(rcClip), VarPtr(uFrameInfo))
        
        
        If pOleInPlaceFrame <> 0 Then
            ' The original was pOleInPlaceFrame.SetActiveObject but IOleInPlaceUIWindow has the definition :/
            Call CallInterface(pOleInPlaceFrame, IOleInPlaceFrame_SetActiveObject, 2, m_uIPAO.ThisPointer, StrPtr(vbNullString))
        End If
        If pOleInPlaceUIWindow <> 0 Then  '-- And Not m_bMouseActivate
            Call CallInterface(pOleInPlaceUIWindow, IOleInPlaceUIWindow_SetActiveObject, 2, VarPtr(m_uIPAO.ThisPointer), StrPtr(vbNullString))
        Else
            Call CallInterface(pOleObject, IOleObject_DoVerb, 6, OLEIVERB_UIACTIVATE, 0, pOleInPlaceSite, 0, UserControl.hwnd, VarPtr(rcPos))
        End If
    End If
    
    On Error GoTo 0
End Sub

Private Function pvTranslateAccel(pMsg As Msg) As Boolean
    
    Const IOleObject_GetClientSite As Long = 4 ' 2 From IUnknown + 2 Ordinal
    Dim pOleObject      As Long 'IOleObject
    Dim pOleControlSite As Long 'IOleControlSite
    Dim uiid As uuid, hEdit As Long
    
    On Error Resume Next
    Select Case pMsg.message
        Case WM_KEYDOWN, WM_KEYUP
            Select Case pMsg.wParam
                Case vbKeyTab
                    If (pvShiftState() And vbCtrlMask) Then
                        Call IIDFromString(StrPtr(IID_IOleObject), uiid)
                        Call CallInterface(ptrMe, IUnknown_Exports.QueryInterface, 2, VarPtr(uiid), VarPtr(pOleObject))
                        Call CallInterface(pOleObject, IOleObject_GetClientSite, 1, VarPtr(pOleControlSite))
                        If pOleControlSite Then
                            Call IIDFromString(StrPtr(IID_IOleControlSite), uiid)
                            Call CallInterface(pOleControlSite, IUnknown_Exports.QueryInterface, 2, VarPtr(uiid), VarPtr(pOleControlSite))
                            Call CallInterface(pOleControlSite, 7, 2, VarPtr(pMsg), pvShiftState() And vbShiftMask)
                        End If
                    End If
                    pvTranslateAccel = False
                Case vbKeyUp, vbKeyDown, vbKeyLeft, vbKeyRight, vbKeyHome, vbKeyEnd, vbKeyPageDown, vbKeyPageUp
                    hEdit = pvEdithWnd()
                    If hEdit Then
                        Call SendMessage(hEdit, pMsg.message, pMsg.wParam, ByVal pMsg.lParam)
                    Else
                        Call SendMessage(m_hListView, pMsg.message, pMsg.wParam, ByVal pMsg.lParam)
                    End If
                    pvTranslateAccel = True
            End Select
    End Select
    On Error GoTo 0
End Function

Private Function GetVTable() As Long
    ' Set up the vTable for the interface and return a pointer to it
    If (m_IPAOVTable(0) = 0) Then
        m_IPAOVTable(0) = scb_SetCallbackAddr(2, 10, Me) ' QueryInterface
        m_IPAOVTable(1) = scb_SetCallbackAddr(1, 12, Me) ' Addref
        m_IPAOVTable(2) = scb_SetCallbackAddr(1, 11, Me) ' Release
        m_IPAOVTable(3) = scb_SetCallbackAddr(2, 9, Me)  ' GetWindow
        m_IPAOVTable(4) = scb_SetCallbackAddr(2, 8, Me)  ' ContextSensitiveHelp
        m_IPAOVTable(5) = scb_SetCallbackAddr(2, 7, Me)  ' TranslateAccelerator
        m_IPAOVTable(6) = scb_SetCallbackAddr(2, 6, Me)  ' OnFrameWindowActivate
        m_IPAOVTable(7) = scb_SetCallbackAddr(2, 5, Me)  ' OnDocWindowActivate
        m_IPAOVTable(8) = scb_SetCallbackAddr(4, 4, Me)  ' ResizeBorder
        m_IPAOVTable(9) = scb_SetCallbackAddr(2, 3, Me)  ' EnableModeless
        '--- init guid
        With IID_IOleInPlaceActiveObject
            .Data1 = &H117&
            .Data4(0) = &HC0
            .Data4(7) = &H46
        End With
    End If
    GetVTable = VarPtr(m_IPAOVTable(0))
End Function

Private Function pvIPAO_AddRef(This As IPAOHookStruct) As Long
    pvIPAO_AddRef = CallInterface(This.IPAOReal, IUnknown_Exports.AddRef, 0)
End Function

Private Function pvIPAO_Release(This As IPAOHookStruct) As Long
    pvIPAO_Release = CallInterface(This.IPAOReal, IUnknown_Exports.Release, 0)
End Function

Private Function pvIPAO_QueryInterface(This As IPAOHookStruct, riid As uuid, pvObj As Long) As Long
    If (IsEqualGUID(riid, IID_IOleInPlaceActiveObject)) Then
        pvObj = VarPtr(This)
        Call pvIPAO_AddRef(This)
        pvIPAO_QueryInterface = 0
      Else
        pvIPAO_QueryInterface = CallInterface(This.IPAOReal, IUnknown_Exports.QueryInterface, 2, VarPtr(riid), VarPtr(pvObj))
    End If
End Function

Private Function pvIPAO_GetWindow(This As IPAOHookStruct, phwnd As Long) As Long
    pvIPAO_GetWindow = CallInterface(This.IPAOReal, IPAO_Exports.GetWindow, 1, VarPtr(phwnd))
End Function

Private Function pvIPAO_ContextSensitiveHelp(This As IPAOHookStruct, ByVal fEnterMode As Long) As Long
    pvIPAO_ContextSensitiveHelp = CallInterface(This.IPAOReal, IPAO_Exports.ContextSensitiveHelp, 1, VarPtr(fEnterMode))
End Function

Private Function pvIPAO_TranslateAccelerator(This As IPAOHookStruct, lpMsg As Msg) As Long
    ' Check if we want to override the handling of this key code:
    If (pvTranslateAccel(lpMsg)) Then
        pvIPAO_TranslateAccelerator = S_OK
    Else
        pvIPAO_TranslateAccelerator = CallInterface(This.IPAOReal, IPAO_Exports.TranslateAccelerator, 1, VarPtr(lpMsg))
    End If
End Function

Private Function pvIPAO_OnFrameWindowActivate(This As IPAOHookStruct, ByVal fActivate As Long) As Long
    pvIPAO_OnFrameWindowActivate = CallInterface(This.IPAOReal, IPAO_Exports.OnFrameWindowActivate, 1, VarPtr(fActivate))
End Function

Private Function pvIPAO_OnDocWindowActivate(This As IPAOHookStruct, ByVal fActivate As Long) As Long
    pvIPAO_OnDocWindowActivate = CallInterface(This.IPAOReal, IPAO_Exports.OnDocWindowActivate, 1, VarPtr(fActivate))
End Function

Private Function pvIPAO_ResizeBorder(This As IPAOHookStruct, prcBorder As RECT, ByVal puiWindow As Long, ByVal fFrameWindow As Long) As Long
    pvIPAO_ResizeBorder = CallInterface(This.IPAOReal, IPAO_Exports.ResizeBorder, 3, VarPtr(prcBorder), puiWindow, VarPtr(fFrameWindow))
End Function

Private Function pvIPAO_EnableModeless(This As IPAOHookStruct, ByVal fEnable As Long) As Long
    pvIPAO_EnableModeless = CallInterface(This.IPAOReal, IPAO_Exports.EnableModeless, 1, VarPtr(fEnable))
End Function

'========================================================================================
' Sorting Routines
'========================================================================================
Private Function pvSortingCallback(ByVal lParam1 As Long, ByVal lParam2 As Long, ByVal SortType As Long) As Long
    If SortType = eSortTypeConstants.stString Or SortType = eSortTypeConstants.stStringSensitive Then
        Dim uLVI   As LVITEM
        Dim a As Long, ps1 As Long, pc1 As Long, ps2 As Long, pc2 As Long
        Dim s1 As String, s2 As String
        a = SORT_STRINGSORT
        If SortType = eSortTypeConstants.stString Then a = a Or NORM_IGNORECASE
        
        s1 = Space$(256)
        s2 = Space$(256)
        
        ps1 = StrPtr(s1)
        ps2 = StrPtr(s2)
        
        With uLVI
            If m_lColumn Then
                .iSubItem = m_lColumn
            End If
            '.mask = LVIF_TEXT
            .pszText = ps1
            .cchTextMax = 256
        End With
        pc1 = SendMessage(m_hListView, LVM_GETITEMTEXT, lParam1, uLVI)
        s1 = Right$(s1, pc1)
        
        With uLVI
            .pszText = ps2
            .cchTextMax = 256
        End With
        pc2 = SendMessage(m_hListView, LVM_GETITEMTEXT, lParam2, uLVI)
        s2 = Right$(s2, pc2)
        
        a = CompareStringW(LOCALE_INVARIANT, a, ps1, pc1, ps2, pc2)
        If a = 3 Then
            pvSortingCallback = m_PRECEDE
        ElseIf a = 1 Then
            pvSortingCallback = m_FOLLOW
        End If
    Else
        Dim Val1
        Dim Val2
        
        If m_lColumn = 0 Then
            Val1 = ItemText(lParam1)
            Val2 = ItemText(lParam2)
        Else
            Val1 = SubItemText(lParam1, m_lColumn)
            Val2 = SubItemText(lParam2, m_lColumn)
        End If
        
        Select Case SortType
            Case eSortTypeConstants.stDate: Val1 = CDate(Val1): Val2 = CDate(Val2)
            Case eSortTypeConstants.stNumeric: Val1 = CDbl(Val1): Val2 = CDbl(Val2)
            Case eSortTypeConstants.stCustom
                    RaiseEvent CustomSort(m_lColumn, lParam1, Val1, lParam2, Val2)
        End Select
        
        If (Val1 > Val2) Then
            pvSortingCallback = m_PRECEDE
        ElseIf (Val1 < Val2) Then
            pvSortingCallback = m_FOLLOW
        End If
    End If
End Function

'========================================================================================
' Subclass handler
'========================================================================================
Private Sub myWndProc(ByVal bBefore As Boolean, ByRef bHandled As Boolean, ByRef lReturn As Long, _
                      ByVal lng_hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long, _
                      ByRef lParamUser As Long)
   Dim uLVHTI   As LVHITTESTINFO
   Dim nCancel  As Integer
   Dim bMouseUp As Boolean
 
   Dim snx      As Single
   Dim sny      As Single
 
   Dim a()      As Byte
   Dim lPos     As Long
   Dim sText    As String
   Dim xx As Long
   Dim xy As Long
   
   Select Case lng_hWnd
       Dim uNMH     As NMHDR
       Dim uNMLV    As NMLISTVIEW
       Dim uNMLVDI  As NMLVDISPINFO
       Dim uNMHE    As NMHEADER
       Dim uHDI     As HDITEM
       Dim uNMLVKD  As NMLVKEYDOWN

       Dim lvScroll As NMLVSCROLL
       Dim pt       As POINTAPI
       Dim itemrect As RECT
       Dim winrect  As RECT
       Case UserControl.hwnd
           Select Case uMsg
               Case WM_MOUSEACTIVATE
                   Call pvSetIPAO
               Case WM_NOTIFY
                   Call RtlMoveMemory(VarPtr(uNMH), lParam, Len(uNMH))
                   If (uNMH.hwndFrom = m_hHeader) Then
                       If (m_hHeader) Then
                           Dim uHDHTI   As HDHITTESTINFO
                           With uHDHTI
                               Call GetCursorPos(.pt)
                               Call ScreenToClient(m_hHeader, .pt)
                               Call SendMessage(m_hHeader, HDM_HITTEST, 0, uHDHTI)
                               Select Case uNMH.code
                                   Case HDN_BEGINTRACK
                                       If m_HeaderFixedWidth Or uHDHTI.iItem = m_rColumn Then
                                           lReturn = 1
                                           bHandled = True
                                       End If
                                   Case HDN_ITEMCLICK
                                       RaiseEvent ColumnClick(.iItem)
                                   Case NM_RCLICK
                                       If (uNMH.hwndFrom = m_hHeader) Then
                                           RaiseEvent ColumnRightClick(.iItem)
                                           lReturn = 1: bHandled = True
                                       End If
                                   Case HDN_DROPDOWN
                                       Call RtlMoveMemory(VarPtr(uNMHE), lParam, Len(uNMHE))
                                       Call SendMessage(m_hHeader, HDM_GETITEMDROPDOWNRECT, uNMHE.iItem, itemrect)
                                       Call GetWindowRect(m_hHeader, winrect)
                                       pt.X = winrect.Left + itemrect.Left
                                       pt.Y = winrect.Top + itemrect.Top
                                       Call ScreenToClient(ContainerHwnd, pt)
                                       snx = pt.X
                                       snx = ScaleX(snx, vbPixels, UserControl.ScaleMode)
                                       sny = pt.Y
                                       sny = ScaleY(sny, vbPixels, UserControl.ScaleMode)
                                       RaiseEvent ColumnMenu(CInt(uHDHTI.iItem), snx, sny)
                                   Case HDN_FILTERBTNCLICK
                                       Dim b As Boolean
                                       RaiseEvent FilterButtonClicked(CInt(uHDHTI.iItem), b)
                                       lReturn = Not b
                                   Case HDN_FILTERCHANGE
                                       Call RtlMoveMemory(VarPtr(uNMHE), lParam, Len(uNMHE))
                                       RaiseEvent FilterTimeout(CInt(uNMHE.iItem))
                                   Case HDN_ITEMCHECK
                                       Call RtlMoveMemory(VarPtr(uNMHE), lParam, Len(uNMHE))
                                       RaiseEvent ColumnCheck(uNMHE.iItem, Not Me.ColumnCheckValue(uNMHE.iItem))
                               End Select
                           End With
                       End If
                   ElseIf (uNMH.hwndFrom = m_hListView) Then
                       Select Case uNMH.code
                           Case NM_CUSTOMDRAW
                                lReturn = pvCustomDraw(lParam)
                                bHandled = True
                                'Call ssc_CallOrigWndProc(lng_hWnd, uMsg, wParam, lParam)
                           
              
                    
                           Case NM_CLICK, NM_RCLICK
                               Call RtlMoveMemory(VarPtr(uNMLV), lParam, Len(uNMLV))
                               With uLVHTI
                                    Call pvUCCoordPixel(.pt.X, .pt.Y)
                                    If uNMH.code = NM_CLICK And m_rColumn <> -1 And Not m_rLocked Then
                                        
                                        If xx <> -1 Then
                                            itemrect.Top = m_rColumn
                                            itemrect.Left = LVIR_BOUNDS
                                            If SendMessage(m_hListView, LVM_GETSUBITEMRECT, xx, itemrect) Then
                                                If PtInRect(itemrect, .pt.X, .pt.Y) Then
                                                    sny = Int((.pt.X - itemrect.Left) / 16) + 1
                                                    RaiseEvent Vote(xx, CInt(sny))
                                                    Call SubItemSet(xx, m_rColumn, sny)
                                                End If
                                            End If
                                        End If
                                    End If
                                    Call SendMessage(m_hListView, LVM_HITTEST, 0, uLVHTI)
                                    If (Not m_MultiSelect) Then
                                        If (.Flags <> LVHT_NOWHERE) Then
                                            If ((.Flags = LVHT_ONITEMICON) Or _
                                                (.Flags = LVHT_ONITEMLABEL) Or _
                                                (.Flags = LVHT_ONITEM)) Then
                                                bMouseUp = True
                                            End If
                                        End If
                                    Else
                                        If (.Flags <> LVHT_ONITEMSTATEICON) Then
                                            bMouseUp = True
                                        End If
                                    End If
                                End With
                                If (bMouseUp) Then
                                    Call pvUCCoordScale(snx, sny)
                                    RaiseEvent MouseUp((uNMH.code = NM_CLICK) + 2, pvShiftState(), snx, sny)
                                    RaiseEvent Click
                               End If
                           Case NM_DBLCLK, NM_RDBLCLK
                                xx = pvItemHitTest
                                If xx <> -1 Then
                                    RaiseEvent ItemDblClick(xx)
                                End If
                           
                               RaiseEvent DblClick
                           Case LVN_ITEMCHANGED
                               Call RtlMoveMemory(VarPtr(uNMLV), lParam, Len(uNMLV))
                               With uNMLV
                                   If (.uOldState) Then
                                       If ((.uNewState And LVIS_STATEIMAGEMASK) <> (.uOldState And LVIS_STATEIMAGEMASK)) Then
                                           RaiseEvent ItemCheck(.iItem)
                                       End If
                                     Else
                                       If (Not m_bFirstItem) Then
                                           If ((.uNewState And LVIS_SELECTED)) Then RaiseEvent ItemClick(.iItem)
                                       End If
                                   End If
                               End With
                               'If m_BackgroundPicture Then
                               '     lReturn = ssc_CallOrigWndProc(UserControl.hwnd, uMsg, wParam, lParam)
                               '     bHandled = True
                               '     Call SendMessage(m_hListView, LVM_REDRAWITEMS, TopIndex, ByVal PageCount)
                               'End If
                           Case LVN_BEGINSCROLL
                           Case LVN_ENDSCROLL
                                Call RtlMoveMemory(VarPtr(lvScroll), lParam, Len(lvScroll))
                                RaiseEvent Scroll(lvScroll.dx, lvScroll.dy)
                           Case LVN_BEGINLABELEDIT
                                RaiseEvent BeforeLabelEdit(nCancel)
                                If (nCancel) Then
                                    Call SendMessage(pvEdithWnd(), WM_KILLFOCUS, 0, ByVal 0)
                                End If
                           Case LVN_ENDLABELEDIT
                                Call RtlMoveMemory(VarPtr(uNMLVDI), lParam, Len(uNMLVDI))
                                With uNMLVDI.item
                                    Dim J As Long
                                    J = lstrlenW(.pszText)
                                    If J Then
                                       sText = String(J, 0)
                                       Call RtlMoveMemory(StrPtr(sText), .pszText, J * 2)
                                    End If
                                    RaiseEvent AfterLabelEdit(nCancel, sText)
                                    If (nCancel = 0 Xor GetAsyncKeyState(vbKeyEscape)) Then
                                        lReturn = 1
                                        bHandled = True
                                    End If
                                End With
                            Case LVN_GROUPHEADERCLICK
                                Call SendMessage(m_hListView, LVM_UPDATE, TopIndex + PageCount, ByVal 0)
                            'Case -16: ' When a group is collapsible
                       End Select
                   End If
           End Select
       Case m_hListView
           Dim lIdx     As Long
           Select Case uMsg
               Case WM_SETFOCUS
                   Call pvSetIPAO
               Case WM_KEYDOWN
                   RaiseEvent KeyDown(wParam And &H7FFF&, pvShiftState())
               Case WM_CHAR
                   RaiseEvent KeyPress(wParam And &H7FFF&)
                   If ((wParam And &H7FFF&) = vbKeySpace) Then
                       lIdx = SendMessage(m_hListView, LVM_GETNEXTITEM, -1, ByVal LVNI_SELECTED Or LVNI_FOCUSED)
                       If (lIdx <> -1) Then RaiseEvent ItemClick(lIdx)
                   End If
               Case WM_KEYUP
                   RaiseEvent KeyUp(wParam And &H7FFF&, pvShiftState())
               Case WM_LBUTTONDOWN, WM_RBUTTONDOWN, WM_MBUTTONDOWN
                   Call pvUCCoordScale(snx, sny)
                   RaiseEvent MouseDown(pvButton(uMsg), pvShiftState(), snx, sny)
                   lIdx = pvItemHitTest()
                   If (lIdx <> -1) Then
                       With uLVHTI
                           Call pvUCCoordPixel(.pt.X, .pt.Y)
                           Call SendMessage(m_hListView, LVM_HITTEST, 0, uLVHTI)
                           If ((.Flags = LVHT_ONITEMICON) Or _
                               (.Flags = LVHT_ONITEMLABEL) Or _
                               (.Flags = LVHT_ONITEM)) Then
                               If (SendMessage(m_hListView, LVM_GETITEMSTATE, lIdx, ByVal LVIS_SELECTED Or LVIS_FOCUSED)) Then
                                   RaiseEvent ItemClick(lIdx)
                               End If
                           End If
                       End With
                   End If
               Case WM_MOUSEMOVE
                    If (Not m_bInCtrl) Then
                        m_bInCtrl = True
                        Call pvTrackMouseLeave(lng_hWnd)
                        RaiseEvent MouseEnter
                    End If
                    Call pvUCCoordScale(snx, sny)
                    If (snx <> m_snxL Or sny <> m_snyL) Then
                        m_snxL = snx
                        m_snyL = sny
                        RaiseEvent MouseMove(pvButton(uMsg), pvShiftState(), snx, sny)
                    End If
                    If m_rColumn <> -1 And Not m_rLocked Then
                        xx = pvItemHitTest
                        If xx <> -1 Then
                            itemrect.Top = m_rColumn
                            itemrect.Left = LVIR_BOUNDS
                            If SendMessage(m_hListView, LVM_GETSUBITEMRECT, xx, itemrect) Then
                                If PtInRect(itemrect, snx, sny) Then
                                    m_rLastIndex = xx
                                End If
                            End If
                        Else
                            m_rLastIndex = -1
                        End If
                        Call RedrawWindow(m_hListView, 0, 0, 1)
                    Else
                        m_rLastIndex = -1
                    End If
               Case WM_MOUSELEAVE
                   m_bInCtrl = False
                   RaiseEvent MouseLeave
                   m_snxL = -1
                   m_snyL = -1
               Case WM_LBUTTONUP, WM_RBUTTONUP, WM_MBUTTONUP
                    Call pvUCCoordScale(snx, sny)
                    RaiseEvent MouseUp(pvButton(uMsg), pvShiftState(), snx, sny)
                    RaiseEvent Click
                Case WM_SYSCOLORCHANGE
                    If Not (m_SubItemProgress = -1 Or m_ViewMode <> vmDetails) Then
                        If hTheme Then Call CloseThemeData(hTheme)
                        If IsThemeActive And m_UseWindowsTheme Then
                            hTheme = OpenThemeData(m_hListView, StrPtr("Progress"))
                        End If
                    End If
           End Select
   End Select
End Sub
